/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.support.Types;
import io.openapiprocessor.jsonschema.validator.object.IdStep;
import io.openapiprocessor.jsonschema.validator.steps.CompositeStep;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Id {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized CompositeStep parentStep) {
        Map<String, Object> properties = this.getInstanceValue(instance);
        Object rawId = properties.get(Keywords.ID);
        if (rawId == null || !this.shouldValidateId(schema)) {
            return;
        }
        IdStep step = new IdStep(schema, instance);
        if (!Types.isString(rawId)) {
            step.setInvalid();
            parentStep.add(step);
            return;
        }
        String id = Types.asString(rawId);
        if (id.contains(Keywords.HASH) && !id.endsWith(Keywords.HASH)) {
            step.setInvalid();
            parentStep.add(step);
            return;
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asObject());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidateId(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return schema.getContext().getVersion().isLaterOrEqualTo201909();
    }
}

