/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonDependency;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.object.DependenciesStep;
import io.openapiprocessor.jsonschema.validator.object.DependencyStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.HashSet;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Dependencies {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public Dependencies(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Map<String, JsonDependency> dependencies = schema.getDependencies();
        if (dependencies == null) {
            return;
        }
        DependenciesStep step = new DependenciesStep(schema, instance);
        Map<String, Object> instanceObject = Null.nonNull(instance.asObject());
        instanceObject.keySet().forEach(propName -> {
            JsonDependency propDependency = (JsonDependency)dependencies.get(propName);
            if (propDependency != null) {
                if (propDependency.isSchema()) {
                    this.validator.validate(propDependency.getSchema(), instance, dynamicScope, step);
                } else {
                    HashSet instanceProperties = new HashSet(instanceObject.keySet());
                    propDependency.getProperties().forEach(p -> {
                        if (!instanceProperties.contains(p)) {
                            DependencyStep depStep = new DependencyStep(schema, instance, (String)p);
                            depStep.setInvalid();
                            step.add(depStep);
                        }
                    });
                }
            }
        });
        parentStep.add(step);
    }
}

