/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.number;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.number.ExclusiveMaximumStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.math.BigDecimal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExclusiveMaximum {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        boolean valid;
        Number maximum = schema.getExclusiveMaximum();
        if (maximum == null) {
            return;
        }
        ExclusiveMaximumStep step = new ExclusiveMaximumStep(schema, instance);
        boolean bl = valid = this.compareTo(instance, maximum) < 0;
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized Number maximum) {
        return new BigDecimal(this.getInstanceValue(instance).toString()).compareTo(new BigDecimal(maximum.toString()));
    }

    private @UnknownKeyFor @NonNull @Initialized Number getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asNumber());
    }
}

