/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.array;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.array.ContainsError;
import io.openapiprocessor.jsonschema.validator.steps.CompositeStep;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ContainsStep
extends CompositeStep {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    private final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;
    private @Nullable @UnknownKeyFor @Initialized Annotation annotation;
    private @UnknownKeyFor @NonNull @Initialized boolean valid = true;

    public ContainsStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        this.schema = schema;
        this.instance = instance;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.valid;
    }

    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ValidationMessage getMessage() {
        if (this.valid) {
            return null;
        }
        return new ContainsError(this.schema, this.instance);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Annotation getAnnotation() {
        return this.annotation;
    }

    public void addAnnotation(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Integer> annotation) {
        this.annotation = new Annotation("contains", annotation);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Annotation> getAnnotations(@UnknownKeyFor @NonNull @Initialized String keyword) {
        Collection<Annotation> composite = super.getAnnotations(keyword);
        if (!keyword.equals("contains")) {
            return composite;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(composite);
        if (this.annotation != null) {
            annotations.add(this.annotation);
        }
        return annotations;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.isValid());
    }

    private @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }
}

