/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.any;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.validator.any.TypeStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Type {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Collection<String> types = schema.getType();
        if (types.isEmpty()) {
            return;
        }
        TypeStep step = new TypeStep(schema, instance);
        boolean matches = false;
        for (String type : types) {
            matches |= this.matches(type, schema, instance);
        }
        if (!matches) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        if ("null".equals(type) && instance.isNull()) {
            return true;
        }
        if ("array".equals(type) && this.isArray(instance)) {
            return true;
        }
        if ("boolean".equals(type) && this.isBoolean(instance)) {
            return true;
        }
        if ("integer".equals(type) && this.isInteger(schema, instance)) {
            return true;
        }
        if ("number".equals(type) && this.isNumber(instance)) {
            return true;
        }
        if ("object".equals(type) && this.isObject(instance)) {
            return true;
        }
        return "string".equals(type) && this.isString(instance);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isBoolean(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return instance.getRawValue() instanceof Boolean;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isInteger(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        boolean isInteger;
        Object value = instance.getRawValue();
        boolean bl = isInteger = value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof BigInteger;
        if (isInteger || this.isDraft4(schema)) {
            return isInteger;
        }
        if (value == null || !this.isNumber(instance)) {
            return false;
        }
        return this.hasZeroFraction(value.toString());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasZeroFraction(@UnknownKeyFor @NonNull @Initialized String value) {
        return new BigDecimal(value).remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNumber(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return instance.getRawValue() instanceof Number;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isString(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return instance.getRawValue() instanceof String;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isObject(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return instance.getRawValue() instanceof Map;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isArray(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return instance.getRawValue() instanceof Collection;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDraft4(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        return SchemaVersion.Draft4.equals((Object)schema.getContext().getVersion());
    }
}

