/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.support;

import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Types {
    private Types() {
    }

    public static <T> T convert(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> type) {
        if (!type.isInstance(value)) {
            throw new TypeMismatchException(path, type);
        }
        return (T)value;
    }

    public static <T> @Nullable T convertOrNull(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> type) {
        if (value == null) {
            return null;
        }
        return Types.convert(path, value, type);
    }

    static <T> T convertOrFallback(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> type, T fallback) {
        if (value == null) {
            return fallback;
        }
        return Types.convert(path, value, type);
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> convertCollection(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value) {
        return Types.convert(path, value, Collection.class);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convertMap(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value) {
        return Types.convert(path, value, Map.class);
    }

    public static @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convertMapOrNull(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized Object value) {
        return Types.convertOrNull(path, value, Map.class);
    }

    public static @PolyNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> asMap(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Map)o;
    }

    public static @PolyNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> asObject(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Map)o;
    }

    public static <T> @PolyNull @UnknownKeyFor @Initialized Collection<T> asCol(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Collection)o;
    }

    public static <T> @PolyNull @UnknownKeyFor @Initialized Collection<T> asArray(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Collection)o;
    }

    public static @PolyNull @UnknownKeyFor @Initialized String asString(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (String)o;
    }

    public static @PolyNull @UnknownKeyFor @Initialized Number asNumber(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Number)o;
    }

    public static @PolyNull @UnknownKeyFor @Initialized Boolean asBoolean(@PolyNull @UnknownKeyFor @Initialized Object o) {
        return (Boolean)o;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isBoolean(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof Boolean;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isString(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof String;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isMap(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof Map;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isObject(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof Map;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isArray(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof Collection;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static @UnknownKeyFor @NonNull @Initialized boolean isSchema(@Nullable @UnknownKeyFor @Initialized Object o) {
        return Types.isObject(o) || Types.isBoolean(o);
    }
}

