/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Ref;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class References {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RefEntry> references = new HashSet<RefEntry>();

    public void add(@UnknownKeyFor @NonNull @Initialized Ref ref) {
        this.references.add(new RefEntry(ref));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Ref ref) {
        return this.references.contains(new RefEntry(ref));
    }

    public void each(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Ref> consumer) {
        for (RefEntry next : this.references) {
            consumer.accept(next.ref);
        }
    }

    private static class RefEntry {
        @UnknownKeyFor @NonNull @Initialized Ref ref;

        public RefEntry(@UnknownKeyFor @NonNull @Initialized Ref ref) {
            this.ref = ref;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefEntry pending = (RefEntry)o;
            return this.ref.getAbsoluteUri().equals(pending.ref.getAbsoluteUri());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.ref.getAbsoluteUri());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.ref.getAbsoluteRef();
        }
    }
}

