/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.ResponseType;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapSetStringsOrEmptyConverter
implements PropertyConverter<Map<String, Set<String>>> {
    private final @UnknownKeyFor @NonNull @Initialized ResponseType responseType;

    public MapSetStringsOrEmptyConverter() {
        this.responseType = ResponseType.EMPTY;
    }

    public MapSetStringsOrEmptyConverter(@UnknownKeyFor @NonNull @Initialized ResponseType responseType) {
        this.responseType = responseType;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        if (value == null) {
            return this.responseType == ResponseType.EMPTY ? Collections.emptyMap() : null;
        }
        Map<String, Object> values = Types.convertMap(location, value);
        LinkedHashMap required = new LinkedHashMap();
        values.forEach((propName, propValue) -> {
            Collection<String> propValues = this.asStrings(Types.convertCollection(this.getLocation(location, (String)propName), propValue));
            required.put(propName, Collections.unmodifiableSet(new LinkedHashSet<String>(propValues)));
        });
        return Collections.unmodifiableMap(required);
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> asStrings(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> values) {
        return values;
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String property) {
        return JsonPointer.from(location).getJsonPointer(property);
    }
}

