/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.JsonSchemaConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapJsonSchemasConverter
implements PropertyConverter<Map<String, JsonSchema>> {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext;

    public MapJsonSchemasConverter(@UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSchema> convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        Map<String, Object> objects = Types.convertMapOrNull(location, value);
        if (objects == null) {
            return null;
        }
        JsonPointer parentLocation = JsonPointer.from(location);
        LinkedHashMap result = new LinkedHashMap();
        objects.forEach((propKey, propValue) -> result.put(propKey, Null.nonNull(this.create(name, propValue, this.getLocation(parentLocation, (String)propKey)))));
        return Collections.unmodifiableMap(result);
    }

    private @Nullable @UnknownKeyFor @Initialized JsonSchema create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        return new JsonSchemaConverter(this.parentContext).convert(name, value, location);
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized JsonPointer parent, @UnknownKeyFor @NonNull @Initialized String property) {
        return parent.getJsonPointer(property);
    }
}

