/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.JsonSchemaObject;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonSchemaConverter
implements PropertyConverter<JsonSchema> {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext;

    public JsonSchemaConverter(@UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JsonSchema convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        if (value == null) {
            return null;
        }
        if (Types.isBoolean(value)) {
            return new JsonSchemaBoolean(JsonPointer.from(location), (Boolean)value, this.parentContext);
        }
        if (Types.isObject(value)) {
            Map<String, Object> props = Types.asObject(value);
            return new JsonSchemaObject(JsonPointer.from(location), props, this.parentContext.withId(props));
        }
        throw new TypeMismatchException(location, JsonSchema.class);
    }
}

