/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BucketConverter
implements PropertyConverter<Bucket> {
    private final @UnknownKeyFor @NonNull @Initialized Bucket parent;

    public BucketConverter(@UnknownKeyFor @NonNull @Initialized Bucket parent) {
        this.parent = parent;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Bucket convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new TypeMismatchException(location, Map.class);
        }
        Map<String, Object> props = Types.asMap(value);
        Scope scope = this.parent.getScope().move(props);
        return new Bucket(scope, location, props);
    }
}

