/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.sync.SyncCredentialsToken;
import io.objectbox.sync.SyncCredentialsUserPassword;

public abstract class SyncCredentials {
    private final CredentialsType type;

    public static SyncCredentials sharedSecret(String secret) {
        return new SyncCredentialsToken(CredentialsType.SHARED_SECRET_SIPPED, secret);
    }

    public static SyncCredentials sharedSecret(byte[] secret) {
        return new SyncCredentialsToken(CredentialsType.SHARED_SECRET_SIPPED, secret);
    }

    public static SyncCredentials google(String idToken) {
        return new SyncCredentialsToken(CredentialsType.GOOGLE, idToken);
    }

    public static SyncCredentials obxAdminUser(String user, String password) {
        return new SyncCredentialsUserPassword(CredentialsType.OBX_ADMIN_USER, user, password);
    }

    public static SyncCredentials userAndPassword(String user, String password) {
        return new SyncCredentialsUserPassword(CredentialsType.USER_PASSWORD, user, password);
    }

    public static SyncCredentials jwtIdToken(String jwtIdToken) {
        return new SyncCredentialsToken(CredentialsType.JWT_ID_TOKEN, jwtIdToken);
    }

    public static SyncCredentials jwtAccessToken(String jwtAccessToken) {
        return new SyncCredentialsToken(CredentialsType.JWT_ACCESS_TOKEN, jwtAccessToken);
    }

    public static SyncCredentials jwtRefreshToken(String jwtRefreshToken) {
        return new SyncCredentialsToken(CredentialsType.JWT_REFRESH_TOKEN, jwtRefreshToken);
    }

    public static SyncCredentials jwtCustomToken(String jwtCustomToken) {
        return new SyncCredentialsToken(CredentialsType.JWT_CUSTOM_TOKEN, jwtCustomToken);
    }

    public static SyncCredentials jwtIdTokenServer() {
        return new SyncCredentialsToken(CredentialsType.JWT_ID_TOKEN);
    }

    public static SyncCredentials jwtAccessTokenServer() {
        return new SyncCredentialsToken(CredentialsType.JWT_ACCESS_TOKEN);
    }

    public static SyncCredentials jwtRefreshTokenServer() {
        return new SyncCredentialsToken(CredentialsType.JWT_REFRESH_TOKEN);
    }

    public static SyncCredentials jwtCustomTokenServer() {
        return new SyncCredentialsToken(CredentialsType.JWT_CUSTOM_TOKEN);
    }

    public static SyncCredentials none() {
        return new SyncCredentialsToken(CredentialsType.NONE);
    }

    SyncCredentials(CredentialsType type) {
        this.type = type;
    }

    public CredentialsType getType() {
        return this.type;
    }

    public long getTypeId() {
        return this.type.id;
    }

    abstract SyncCredentials createClone();

    public static enum CredentialsType {
        NONE(1L),
        GOOGLE(3L),
        SHARED_SECRET_SIPPED(4L),
        OBX_ADMIN_USER(5L),
        USER_PASSWORD(6L),
        JWT_ID_TOKEN(7L),
        JWT_ACCESS_TOKEN(8L),
        JWT_REFRESH_TOKEN(9L),
        JWT_CUSTOM_TOKEN(10L);

        public final long id;

        private CredentialsType(long id) {
            this.id = id;
        }
    }
}

