/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.sync.SyncBuilder;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncHybridBuilder;
import io.objectbox.sync.server.SyncServerBuilder;
import java.util.Arrays;

public final class Sync {
    public static boolean isAvailable() {
        return BoxStore.isSyncAvailable();
    }

    public static boolean isServerAvailable() {
        return BoxStore.isSyncServerAvailable();
    }

    public static boolean isHybridAvailable() {
        return Sync.isAvailable() && Sync.isServerAvailable();
    }

    public static SyncBuilder client(BoxStore boxStore) {
        return new SyncBuilder(boxStore);
    }

    @Deprecated
    public static SyncBuilder client(BoxStore boxStore, String url, SyncCredentials credentials) {
        return Sync.client(boxStore).url(url).credentials(credentials);
    }

    @Deprecated
    public static SyncBuilder client(BoxStore boxStore, String url, SyncCredentials[] multipleCredentials) {
        SyncBuilder builder = Sync.client(boxStore).url(url);
        if (multipleCredentials != null) {
            builder.credentials(Arrays.asList(multipleCredentials));
        }
        return builder;
    }

    public static SyncServerBuilder server(BoxStore boxStore, String url, SyncCredentials authenticatorCredentials) {
        return new SyncServerBuilder(boxStore, url, authenticatorCredentials);
    }

    public static SyncServerBuilder server(BoxStore boxStore, String url, SyncCredentials[] multipleAuthenticatorCredentials) {
        return new SyncServerBuilder(boxStore, url, multipleAuthenticatorCredentials);
    }

    public static SyncHybridBuilder hybrid(BoxStoreBuilder storeBuilder, String url, SyncCredentials authenticatorCredentials) {
        return new SyncHybridBuilder(storeBuilder, url, authenticatorCredentials);
    }

    private Sync() {
    }
}

