/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.internal;

import io.objectbox.BoxStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.greenrobot.essentials.io.IoUtils;

public class NativeLibraryLoader {
    private static final String OBJECTBOX_JNI = "objectbox-jni";

    private static String getCpuArch() {
        String osArch = System.getProperty("os.arch");
        String cpuArch = null;
        if (osArch != null) {
            if ((osArch = osArch.toLowerCase()).equalsIgnoreCase("amd64") || osArch.equalsIgnoreCase("x86_64")) {
                cpuArch = "x64";
            } else if (osArch.equalsIgnoreCase("x86")) {
                cpuArch = "x86";
            } else if ("aarch64".equals(osArch) || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
                cpuArch = "arm64";
            } else if (osArch.startsWith("arm")) {
                String cpuArchOSOrNull;
                if (osArch.startsWith("armv7") || osArch.startsWith("armeabi-v7")) {
                    cpuArch = "armv7";
                } else if (osArch.startsWith("armv6")) {
                    cpuArch = "armv6";
                } else if ("arm".equals(osArch) && (cpuArchOSOrNull = NativeLibraryLoader.getCpuArchOSOrNull()) != null) {
                    String cpuArchOS = cpuArchOSOrNull.toLowerCase();
                    if (cpuArchOS.startsWith("armv7")) {
                        cpuArch = "armv7";
                    } else if (cpuArchOS.startsWith("armv6")) {
                        cpuArch = "armv6";
                    }
                }
                if (cpuArch == null) {
                    cpuArch = "armv6";
                    System.err.printf("[ObjectBox] 32-bit ARM os.arch unknown (will use %s), please report this to us: os.arch=%s, machine=%s%n", cpuArch, osArch, NativeLibraryLoader.getCpuArchOSOrNull());
                }
            }
        }
        if (cpuArch == null) {
            String sunArch = System.getProperty("sun.arch.data.model");
            cpuArch = "64".equals(sunArch) ? "x64" : ("32".equals(sunArch) ? "x86" : "unknown");
            System.err.printf("[ObjectBox] os.arch unknown (will use %s), please report this to us: os.arch=%s, model=%s, machine=%s%n", cpuArch, osArch, sunArch, NativeLibraryLoader.getCpuArchOSOrNull());
        }
        return cpuArch;
    }

    @Nullable
    private static String getCpuArchOSOrNull() {
        String archOrNull = null;
        try {
            Process exec = Runtime.getRuntime().exec("uname -m");
            BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream(), Charset.defaultCharset()));
            archOrNull = reader.readLine();
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return archOrNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUnpackLib(String filename) {
        block11: {
            String path = "/native/" + filename;
            URL resource = NativeLibraryLoader.class.getResource(path);
            if (resource == null) {
                System.err.println("Not available in classpath: " + path);
            } else {
                File file = new File(filename);
                try {
                    URLConnection urlConnection = resource.openConnection();
                    int length = urlConnection.getContentLength();
                    long lastModified = urlConnection.getLastModified();
                    if (file.exists() && file.length() == (long)length && file.lastModified() == lastModified) break block11;
                    BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                        try {
                            IoUtils.copyAllBytes((InputStream)in, (OutputStream)out);
                        }
                        finally {
                            IoUtils.safeClose((Closeable)out);
                        }
                    }
                    finally {
                        IoUtils.safeClose((Closeable)in);
                    }
                    if (lastModified > 0L) {
                        file.setLastModified(lastModified);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean loadLibraryAndroid() {
        if (BoxStore.getContext() == null) {
            return false;
        }
        try {
            Class<?> context = Class.forName("android.content.Context");
            if (BoxStore.getRelinker() == null) {
                Class<?> relinker = Class.forName("com.getkeepsafe.relinker.ReLinker");
                Method loadLibrary = relinker.getMethod("loadLibrary", context, String.class, String.class);
                loadLibrary.invoke(null, BoxStore.getContext(), OBJECTBOX_JNI, "5.1.1-2026-02-16");
            } else {
                Method loadLibrary = BoxStore.getRelinker().getClass().getMethod("loadLibrary", context, String.class, String.class);
                loadLibrary.invoke(BoxStore.getRelinker(), BoxStore.getContext(), OBJECTBOX_JNI, "5.1.1-2026-02-16");
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Nonnull
    private static String getSupportedABIsAndroid() {
        String[] supportedAbis = null;
        try {
            Class<?> build = Class.forName("android.os.Build");
            Field supportedAbisField = build.getField("SUPPORTED_ABIS");
            supportedAbis = (String[])supportedAbisField.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (supportedAbis != null) {
            return Arrays.toString(supportedAbis);
        }
        return "";
    }

    public static void ensureLoaded() {
    }

    static {
        block18: {
            String libname = OBJECTBOX_JNI;
            String filename = libname + ".so";
            String vendor = System.getProperty("java.vendor");
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isLinux = true;
            boolean android = vendor.contains("Android");
            if (!android) {
                if (osName.contains("mac")) {
                    isLinux = false;
                    libname = libname + "-macos";
                    filename = "lib" + libname + ".dylib";
                    NativeLibraryLoader.checkUnpackLib(filename);
                } else {
                    String cpuArchPostfix = "-" + NativeLibraryLoader.getCpuArch();
                    if (osName.contains("windows")) {
                        isLinux = false;
                        libname = libname + "-windows" + cpuArchPostfix;
                        filename = libname + ".dll";
                        NativeLibraryLoader.checkUnpackLib(filename);
                    } else if (osName.contains("linux")) {
                        libname = libname + "-linux" + cpuArchPostfix;
                        filename = "lib" + libname + ".so";
                        NativeLibraryLoader.checkUnpackLib(filename);
                    }
                }
            }
            try {
                File file = new File(filename);
                if (file.exists()) {
                    System.load(file.getAbsolutePath());
                    break block18;
                }
                try {
                    if (android) {
                        boolean success = NativeLibraryLoader.loadLibraryAndroid();
                        if (!success) {
                            System.loadLibrary(libname);
                        }
                    } else {
                        System.err.println("File not available: " + file.getAbsolutePath());
                        System.loadLibrary(libname);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    if (!android && isLinux) {
                        boolean success = NativeLibraryLoader.loadLibraryAndroid();
                        if (!success) {
                            System.loadLibrary(OBJECTBOX_JNI);
                        }
                        break block18;
                    }
                    throw e;
                }
            }
            catch (UnsatisfiedLinkError e) {
                String message;
                String osArch = System.getProperty("os.arch");
                if (android) {
                    message = String.format("[ObjectBox] Android failed to load native library, check your APK/App Bundle includes a supported ABI or use ReLinker https://docs.objectbox.io/android/app-bundle-and-split-apk (vendor=%s,os=%s,os.arch=%s,SUPPORTED_ABIS=%s)", vendor, osName, osArch, NativeLibraryLoader.getSupportedABIsAndroid());
                } else {
                    String sunArch = System.getProperty("sun.arch.data.model");
                    message = String.format("[ObjectBox] Loading native library failed, please report this to us: vendor=%s,os=%s,os.arch=%s,model=%s,linux=%s,machine=%s", vendor, osName, osArch, sunArch, isLinux, NativeLibraryLoader.getCpuArchOSOrNull());
                }
                throw new LinkageError(message, e);
            }
        }
    }
}

