/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.internal;

import io.objectbox.InternalAccess;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Beta;
import io.objectbox.exception.DbException;
import java.io.Closeable;

@Beta
public class DebugCursor
implements Closeable {
    private final Transaction tx;
    private final long handle;
    private boolean closed;

    static native long nativeCreate(long var0);

    static native void nativeDestroy(long var0);

    static native byte[] nativeGet(long var0, byte[] var2);

    static native byte[] nativeSeekOrNext(long var0, byte[] var2);

    public static DebugCursor create(Transaction tx) {
        long txHandle = InternalAccess.getHandle(tx);
        long handle = DebugCursor.nativeCreate(txHandle);
        if (handle == 0L) {
            throw new DbException("Could not create native debug cursor");
        }
        return new DebugCursor(tx, handle);
    }

    public DebugCursor(Transaction tx, long handle) {
        this.tx = tx;
        this.handle = handle;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.tx != null && !this.tx.getStore().isClosed()) {
                DebugCursor.nativeDestroy(this.handle);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
            super.finalize();
        }
    }

    public byte[] get(byte[] key) {
        return DebugCursor.nativeGet(this.handle, key);
    }

    public byte[] seekOrNext(byte[] key) {
        return DebugCursor.nativeSeekOrNext(this.handle, key);
    }
}

