/*
 * Copyright 2026 ObjectBox Ltd. https://objectbox.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.sync;

/**
 * Flags to adjust sync behavior like additional logging.
 */
@SuppressWarnings("unused")
public final class SyncFlags {
  private SyncFlags() { }
  /**
   * Enable (rather extensive) logging on how IDs are mapped (local &lt;-&gt; global)
   */
  public static final int DebugLogIdMapping = 1;
  /**
   * If the client gets in a state that does not allow any further synchronization, this flag instructs Sync to
   * keep local data nevertheless. While this preserves data, you need to resolve the situation manually.
   * For example, you could backup the data and start with a fresh database.
   * Note that the default behavior (this flag is not set) is to wipe existing data from all sync-enabled types and
   * sync from scratch from the server.
   * Client-only: setting this flag for Sync server has no effect.
   */
  public static final int ClientKeepDataOnSyncError = 2;
  /**
   * Logs sync filter variables used for each client, e.g. values provided by JWT or the client's login message.
   * Server-only: setting this flag for Sync client has no effect.
   */
  public static final int DebugLogFilterVariables = 4;
  /**
   * When set, remove operations will include the full object data in the TX log (REMOVE_OBJECT command).
   * This allows sync filters to filter out remove operations based on the object content.
   * Without this flag, remove operations only contain the object ID and cannot be filtered.
   * Note: this increases the size of TX logs for remove operations.
   */
  public static final int RemoveWithObjectData = 8;
  /**
   * Enables debug logging of TX log processing.
   * For now, this only has an effect on SyncClients (Sync Server has extensive debug logs already).
   */
  public static final int DebugLogTxLogs = 16;
  /**
   * Skips invalid (put object) operations in the TX log instead of failing.
   */
  public static final int SkipInvalidTxOps = 32;
}

