/*
 * Copyright 2024 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.sync;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.BooleanVector;
import io.objectbox.flatbuffers.ByteVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.DoubleVector;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.FloatVector;
import io.objectbox.flatbuffers.IntVector;
import io.objectbox.flatbuffers.LongVector;
import io.objectbox.flatbuffers.ShortVector;
import io.objectbox.flatbuffers.StringVector;
import io.objectbox.flatbuffers.Struct;
import io.objectbox.flatbuffers.Table;
import io.objectbox.flatbuffers.UnionVector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * Credentials consist of a type and the credentials data to perform authentication checks.
 * The data is either provided as plain-bytes, or as a list of strings.
 * Credentials can be used from the client and server side.
 * This depends on the type however:
 * for example, shared secrets are configured at both sides, but username/password is only provided at the client.
 */
@SuppressWarnings("unused")
public final class Credentials extends Table {
  public static void ValidateVersion() { Constants.FLATBUFFERS_23_5_26(); }
  public static Credentials getRootAsCredentials(ByteBuffer _bb) { return getRootAsCredentials(_bb, new Credentials()); }
  public static Credentials getRootAsCredentials(ByteBuffer _bb, Credentials obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __reset(_i, _bb); }
  public Credentials __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  public long type() { int o = __offset(4); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * Credentials provided by plain bytes.
   * This is used for shared secrets (client & server).
   */
  public int bytes(int j) { int o = __offset(6); return o != 0 ? bb.get(__vector(o) + j * 1) & 0xFF : 0; }
  public int bytesLength() { int o = __offset(6); return o != 0 ? __vector_len(o) : 0; }
  public ByteVector bytesVector() { return bytesVector(new ByteVector()); }
  public ByteVector bytesVector(ByteVector obj) { int o = __offset(6); return o != 0 ? obj.__assign(__vector(o), bb) : null; }
  public ByteBuffer bytesAsByteBuffer() { return __vector_as_bytebuffer(6, 1); }
  public ByteBuffer bytesInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 6, 1); }
  /**
   * Credentials provided by a string array.
   * For username/password (client-only), provide the username in strings[0] and the password in strings[1].
   * For GoogleAuth, you can provide a list of accepted IDs (server-only).
   */
  public String strings(int j) { int o = __offset(8); return o != 0 ? __string(__vector(o) + j * 4) : null; }
  public int stringsLength() { int o = __offset(8); return o != 0 ? __vector_len(o) : 0; }
  public StringVector stringsVector() { return stringsVector(new StringVector()); }
  public StringVector stringsVector(StringVector obj) { int o = __offset(8); return o != 0 ? obj.__assign(__vector(o), 4, bb) : null; }

  public static int createCredentials(FlatBufferBuilder builder,
      long type,
      int bytesOffset,
      int stringsOffset) {
    builder.startTable(3);
    Credentials.addStrings(builder, stringsOffset);
    Credentials.addBytes(builder, bytesOffset);
    Credentials.addType(builder, type);
    return Credentials.endCredentials(builder);
  }

  public static void startCredentials(FlatBufferBuilder builder) { builder.startTable(3); }
  public static void addType(FlatBufferBuilder builder, long type) { builder.addInt(0, (int) type, (int) 0L); }
  public static void addBytes(FlatBufferBuilder builder, int bytesOffset) { builder.addOffset(1, bytesOffset, 0); }
  public static int createBytesVector(FlatBufferBuilder builder, byte[] data) { return builder.createByteVector(data); }
  public static int createBytesVector(FlatBufferBuilder builder, ByteBuffer data) { return builder.createByteVector(data); }
  public static void startBytesVector(FlatBufferBuilder builder, int numElems) { builder.startVector(1, numElems, 1); }
  public static void addStrings(FlatBufferBuilder builder, int stringsOffset) { builder.addOffset(2, stringsOffset, 0); }
  public static int createStringsVector(FlatBufferBuilder builder, int[] data) { builder.startVector(4, data.length, 4); for (int i = data.length - 1; i >= 0; i--) builder.addOffset(data[i]); return builder.endVector(); }
  public static void startStringsVector(FlatBufferBuilder builder, int numElems) { builder.startVector(4, numElems, 4); }
  public static int endCredentials(FlatBufferBuilder builder) {
    int o = builder.endTable();
    return o;
  }

  public static final class Vector extends BaseVector {
    public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) { __reset(_vector, _element_size, _bb); return this; }

    public Credentials get(int j) { return get(new Credentials(), j); }
    public Credentials get(Credentials obj, int j) {  return obj.__assign(__indirect(__element(j), bb), bb); }
  }
}

