/*
 * Copyright 2025 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

/**
 * A property type of an external system (e.g. another database) that has no default mapping to an ObjectBox type.
 * External property types numeric values start at 100 to avoid overlaps with ObjectBox's PropertyType.
 * (And if we ever support one of these as a primary type, we could share the numeric value?)
 */
@SuppressWarnings("unused")
public final class ExternalPropertyType {
  private ExternalPropertyType() { }
  /**
   * Not a real type: represents uninitialized state and can be used for forward compatibility.
   */
  public static final short Unknown = 0;
  /**
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation, little endian (16 bytes)
   */
  public static final short Int128 = 100;
  public static final short Reserved1 = 101;
  /**
   * A UUID (Universally Unique Identifier) as defined by RFC 9562.
   * ObjectBox uses the UUIDv7 scheme (timestamp + random) to create new UUIDs.
   * UUIDv7 is a good choice for database keys as it's mostly sequential and encodes a timestamp.
   * However, if keys are used externally, consider UuidV4 for better privacy by not exposing any time information.
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (16 bytes)
   */
  public static final short Uuid = 102;
  /**
   * IEEE 754 decimal128 type, e.g. supported by MongoDB
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (16 bytes)
   */
  public static final short Decimal128 = 103;
  /**
   * UUID represented as a string of 36 characters, e.g. "019571b4-80e3-7516-a5c1-5f1053d23fff".
   * For efficient storage, consider the Uuid type instead, which occupies only 16 bytes (20 bytes less).
   * This type may still be a convenient alternative as the string type is widely supported and more human-readable.
   * In accordance to standards, new UUIDs generated by ObjectBox use lowercase hexadecimal digits.
   * Representing type: String
   */
  public static final short UuidString = 104;
  /**
   * A UUID (Universally Unique Identifier) as defined by RFC 9562.
   * ObjectBox uses the UUIDv4 scheme (completely random) to create new UUIDs.
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (16 bytes)
   */
  public static final short UuidV4 = 105;
  /**
   * Like UuidString, but using the UUIDv4 scheme (completely random) to create new UUID.
   * Representing type: String
   */
  public static final short UuidV4String = 106;
  /**
   * A key/value map; e.g. corresponds to a JSON object or a MongoDB document (although not keeping the key order).
   * Unlike the Flex type, this must contain a map value (e.g. not a vector or a scalar).
   * Representing type: Flex
   * Encoding: Flex
   */
  public static final short FlexMap = 107;
  /**
   * A vector (aka list or array) of flexible elements; e.g. corresponds to a JSON array or a MongoDB array.
   * Unlike the Flex type, this must contain a vector value (e.g. not a map or a scalar).
   * Representing type: Flex
   * Encoding: Flex
   */
  public static final short FlexVector = 108;
  /**
   * Placeholder (not yet used) for a JSON document.
   * Representing type: String
   */
  public static final short Json = 109;
  /**
   * Placeholder (not yet used) for a BSON document.
   * Representing type: ByteVector
   */
  public static final short Bson = 110;
  /**
   * JavaScript source code
   * Representing type: String
   */
  public static final short JavaScript = 111;
  /**
   * A JSON string that is converted to a native "complex" representation in the external system.
   * For example in MongoDB, embedded/nested documents are converted to a JSON string in ObjectBox and vice versa.
   * This allows a quick and simple way to work with non-normalized data from MongoDB in ObjectBox.
   * Alternatively, you can use FlexMap and FlexVector to map to language primitives (e.g. maps with string keys;
   * not supported by all ObjectBox languages yet).
   * For MongoDB, (nested) documents and arrays are supported.
   * Note that this is very close to the internal representation, e.g. the key order is preserved (unlike Flex).
   * Representing type: String
   */
  public static final short JsonToNative = 112;
  public static final short Reserved6 = 113;
  public static final short Reserved7 = 114;
  public static final short Reserved8 = 115;
  /**
   * A vector (array) of Int128 values
   */
  public static final short Int128Vector = 116;
  public static final short Reserved9 = 117;
  /**
   * A vector (array) of UUID values
   */
  public static final short UuidVector = 118;
  public static final short Reserved10 = 119;
  public static final short Reserved11 = 120;
  public static final short Reserved12 = 121;
  public static final short Reserved13 = 122;
  /**
   * The 12-byte ObjectId type in MongoDB
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (12 bytes)
   */
  public static final short MongoId = 123;
  /**
   * A vector (array) of MongoId values
   */
  public static final short MongoIdVector = 124;
  /**
   * Representing type: Long
   * Encoding: Two unsigned 32-bit integers merged into a 64-bit integer.
   */
  public static final short MongoTimestamp = 125;
  /**
   * Representing type: ByteVector
   * Encoding: 3 zero bytes (reserved, functions as padding), fourth byte is the sub-type,
   * followed by the binary data.
   */
  public static final short MongoBinary = 126;
  /**
   * Representing type: string vector with 2 elements (index 0: pattern, index 1: options)
   * Encoding: 1:1 string representation
   */
  public static final short MongoRegex = 127;

  public static final String[] names = { "Unknown", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Int128", "Reserved1", "Uuid", "Decimal128", "UuidString", "UuidV4", "UuidV4String", "FlexMap", "FlexVector", "Json", "Bson", "JavaScript", "JsonToNative", "Reserved6", "Reserved7", "Reserved8", "Int128Vector", "Reserved9", "UuidVector", "Reserved10", "Reserved11", "Reserved12", "Reserved13", "MongoId", "MongoIdVector", "MongoTimestamp", "MongoBinary", "MongoRegex", };

  public static String name(int e) { return names[e]; }
}

