/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.internal;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class ObjectBoxThreadPool
extends ThreadPoolExecutor {
    public static String THREAD_NAME_PREFIX = "ObjectBox-";
    private final BoxStore boxStore;

    public ObjectBoxThreadPool(BoxStore boxStore) {
        super(0, Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ObjectBoxThreadFactory());
        this.boxStore = boxStore;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        this.boxStore.closeThreadResources();
    }

    static class ObjectBoxThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_COUNT = new AtomicInteger();
        private final ThreadGroup group;
        private final String namePrefix = THREAD_NAME_PREFIX + POOL_COUNT.incrementAndGet() + "-Thread-";
        private final AtomicInteger threadCount = new AtomicInteger();

        ObjectBoxThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String name = this.namePrefix + this.threadCount.incrementAndGet();
            Thread thread = new Thread(this.group, runnable, name);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            return thread;
        }
    }
}

