/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.tree;

import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.tree.Leaf;
import io.objectbox.tree.LeafNode;
import io.objectbox.tree.Tree;
import javax.annotation.Nullable;

@Experimental
public class Branch {
    private final Tree tree;
    private final long id;

    Branch(Tree tree, long id) {
        this.tree = tree;
        this.id = id;
    }

    public Tree getTree() {
        return this.tree;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public Branch branch(String[] path) {
        this.checkPath(path);
        long branchId = this.nativeGetBranchId(this.tree.getHandle(), this.id, path);
        if (branchId == 0L) {
            return null;
        }
        return new Branch(this.tree, branchId);
    }

    @Nullable
    public Branch branch(String pathString) {
        this.checkNameOrPath(pathString);
        String[] path = pathString.split(this.tree.getPathSeparatorRegex());
        return this.branch(path);
    }

    @Nullable
    public Branch branchChild(String name) {
        String[] path = new String[]{name};
        return this.branch(path);
    }

    @Nullable
    public Leaf leaf(String[] path) {
        this.checkPath(path);
        LeafNode leafNode = this.nativeGetLeaf(this.tree.getHandle(), this.id, path);
        if (leafNode == null) {
            return null;
        }
        return new Leaf(leafNode);
    }

    @Nullable
    public Leaf leaf(String pathString) {
        this.checkNameOrPath(pathString);
        String[] path = pathString.split(this.tree.getPathSeparatorRegex());
        return this.leaf(path);
    }

    @Nullable
    public Leaf leafChild(String name) {
        this.checkNameOrPath(name);
        String[] path = new String[]{name};
        return this.leaf(path);
    }

    private void checkNameOrPath(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name/path must not be null or empty");
        }
    }

    private void checkPath(String[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path must not be null or empty");
        }
    }

    private native long nativeGetBranchId(long var1, long var3, String[] var5);

    private native LeafNode nativeGetLeaf(long var1, long var3, String[] var5);
}

