/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.IntVector;
import io.objectbox.flatbuffers.Table;
import io.objectbox.sync.Credentials;
import io.objectbox.sync.server.ClusterPeerConfig;
import io.objectbox.sync.server.JwtConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class SyncServerOptions
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static SyncServerOptions getRootAsSyncServerOptions(ByteBuffer _bb) {
        return SyncServerOptions.getRootAsSyncServerOptions(_bb, new SyncServerOptions());
    }

    public static SyncServerOptions getRootAsSyncServerOptions(ByteBuffer _bb, SyncServerOptions obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SyncServerOptions __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String url() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer urlAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer urlInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public Credentials authenticationMethods(int j) {
        return this.authenticationMethods(new Credentials(), j);
    }

    public Credentials authenticationMethods(Credentials obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int authenticationMethodsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Credentials.Vector authenticationMethodsVector() {
        return this.authenticationMethodsVector(new Credentials.Vector());
    }

    public Credentials.Vector authenticationMethodsVector(Credentials.Vector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public long syncFlags() {
        int o = this.__offset(8);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public long syncServerFlags() {
        int o = this.__offset(10);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public String certificatePath() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer certificatePathAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer certificatePathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public long workerThreads() {
        int o = this.__offset(14);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public long historySizeMaxKb() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long historySizeTargetKb() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public String adminUrl() {
        int o = this.__offset(20);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer adminUrlAsByteBuffer() {
        return this.__vector_as_bytebuffer(20, 1);
    }

    public ByteBuffer adminUrlInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 20, 1);
    }

    public long adminThreads() {
        int o = this.__offset(22);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public String clusterId() {
        int o = this.__offset(24);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer clusterIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(24, 1);
    }

    public ByteBuffer clusterIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 24, 1);
    }

    public ClusterPeerConfig clusterPeers(int j) {
        return this.clusterPeers(new ClusterPeerConfig(), j);
    }

    public ClusterPeerConfig clusterPeers(ClusterPeerConfig obj, int j) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int clusterPeersLength() {
        int o = this.__offset(26);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ClusterPeerConfig.Vector clusterPeersVector() {
        return this.clusterPeersVector(new ClusterPeerConfig.Vector());
    }

    public ClusterPeerConfig.Vector clusterPeersVector(ClusterPeerConfig.Vector obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public long clusterFlags() {
        int o = this.__offset(28);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public JwtConfig jwtConfig() {
        return this.jwtConfig(new JwtConfig());
    }

    public JwtConfig jwtConfig(JwtConfig obj) {
        int o = this.__offset(30);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public long requiredCredentials(int j) {
        int o = this.__offset(32);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int requiredCredentialsLength() {
        int o = this.__offset(32);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector requiredCredentialsVector() {
        return this.requiredCredentialsVector(new IntVector());
    }

    public IntVector requiredCredentialsVector(IntVector obj) {
        int o = this.__offset(32);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer requiredCredentialsAsByteBuffer() {
        return this.__vector_as_bytebuffer(32, 4);
    }

    public ByteBuffer requiredCredentialsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 32, 4);
    }

    public static int createSyncServerOptions(FlatBufferBuilder builder, int urlOffset, int authenticationMethodsOffset, long syncFlags, long syncServerFlags, int certificatePathOffset, long workerThreads, long historySizeMaxKb, long historySizeTargetKb, int adminUrlOffset, long adminThreads, int clusterIdOffset, int clusterPeersOffset, long clusterFlags, int jwtConfigOffset, int requiredCredentialsOffset) {
        builder.startTable(15);
        SyncServerOptions.addHistorySizeTargetKb(builder, historySizeTargetKb);
        SyncServerOptions.addHistorySizeMaxKb(builder, historySizeMaxKb);
        SyncServerOptions.addRequiredCredentials(builder, requiredCredentialsOffset);
        SyncServerOptions.addJwtConfig(builder, jwtConfigOffset);
        SyncServerOptions.addClusterFlags(builder, clusterFlags);
        SyncServerOptions.addClusterPeers(builder, clusterPeersOffset);
        SyncServerOptions.addClusterId(builder, clusterIdOffset);
        SyncServerOptions.addAdminThreads(builder, adminThreads);
        SyncServerOptions.addAdminUrl(builder, adminUrlOffset);
        SyncServerOptions.addWorkerThreads(builder, workerThreads);
        SyncServerOptions.addCertificatePath(builder, certificatePathOffset);
        SyncServerOptions.addSyncServerFlags(builder, syncServerFlags);
        SyncServerOptions.addSyncFlags(builder, syncFlags);
        SyncServerOptions.addAuthenticationMethods(builder, authenticationMethodsOffset);
        SyncServerOptions.addUrl(builder, urlOffset);
        return SyncServerOptions.endSyncServerOptions(builder);
    }

    public static void startSyncServerOptions(FlatBufferBuilder builder) {
        builder.startTable(15);
    }

    public static void addUrl(FlatBufferBuilder builder, int urlOffset) {
        builder.addOffset(0, urlOffset, 0);
    }

    public static void addAuthenticationMethods(FlatBufferBuilder builder, int authenticationMethodsOffset) {
        builder.addOffset(1, authenticationMethodsOffset, 0);
    }

    public static int createAuthenticationMethodsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startAuthenticationMethodsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addSyncFlags(FlatBufferBuilder builder, long syncFlags) {
        builder.addInt(2, (int)syncFlags, 0);
    }

    public static void addSyncServerFlags(FlatBufferBuilder builder, long syncServerFlags) {
        builder.addInt(3, (int)syncServerFlags, 0);
    }

    public static void addCertificatePath(FlatBufferBuilder builder, int certificatePathOffset) {
        builder.addOffset(4, certificatePathOffset, 0);
    }

    public static void addWorkerThreads(FlatBufferBuilder builder, long workerThreads) {
        builder.addInt(5, (int)workerThreads, 0);
    }

    public static void addHistorySizeMaxKb(FlatBufferBuilder builder, long historySizeMaxKb) {
        builder.addLong(6, historySizeMaxKb, 0L);
    }

    public static void addHistorySizeTargetKb(FlatBufferBuilder builder, long historySizeTargetKb) {
        builder.addLong(7, historySizeTargetKb, 0L);
    }

    public static void addAdminUrl(FlatBufferBuilder builder, int adminUrlOffset) {
        builder.addOffset(8, adminUrlOffset, 0);
    }

    public static void addAdminThreads(FlatBufferBuilder builder, long adminThreads) {
        builder.addInt(9, (int)adminThreads, 0);
    }

    public static void addClusterId(FlatBufferBuilder builder, int clusterIdOffset) {
        builder.addOffset(10, clusterIdOffset, 0);
    }

    public static void addClusterPeers(FlatBufferBuilder builder, int clusterPeersOffset) {
        builder.addOffset(11, clusterPeersOffset, 0);
    }

    public static int createClusterPeersVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startClusterPeersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addClusterFlags(FlatBufferBuilder builder, long clusterFlags) {
        builder.addInt(12, (int)clusterFlags, 0);
    }

    public static void addJwtConfig(FlatBufferBuilder builder, int jwtConfigOffset) {
        builder.addOffset(13, jwtConfigOffset, 0);
    }

    public static void addRequiredCredentials(FlatBufferBuilder builder, int requiredCredentialsOffset) {
        builder.addOffset(14, requiredCredentialsOffset, 0);
    }

    public static int createRequiredCredentialsVector(FlatBufferBuilder builder, long[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt((int)data[i]);
        }
        return builder.endVector();
    }

    public static void startRequiredCredentialsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endSyncServerOptions(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishSyncServerOptionsBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedSyncServerOptionsBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SyncServerOptions get(int j) {
            return this.get(new SyncServerOptions(), j);
        }

        public SyncServerOptions get(SyncServerOptions obj, int j) {
            return obj.__assign(SyncServerOptions.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

