/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.EntityInfo;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.converter.PropertyConverter;
import io.objectbox.exception.DbException;
import io.objectbox.query.PropertyQueryCondition;
import io.objectbox.query.PropertyQueryConditionImpl;
import io.objectbox.query.QueryBuilder;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nullable;

public class Property<ENTITY>
implements Serializable {
    private static final long serialVersionUID = 8613291105982758093L;
    public final EntityInfo<ENTITY> entity;
    public final int ordinal;
    public final int id;
    public final Class<?> type;
    public final String name;
    public final boolean isId;
    public final boolean isVirtual;
    public final String dbName;
    public final Class<? extends PropertyConverter> converterClass;
    public final Class<?> customType;
    private boolean idVerified;

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name) {
        this(entity, ordinal, id, type, name, false, name, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isVirtual) {
        this(entity, ordinal, id, type, name, false, isVirtual, name, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, @Nullable String dbName) {
        this(entity, ordinal, id, type, name, isId, dbName, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, @Nullable String dbName, @Nullable Class<? extends PropertyConverter> converterClass, @Nullable Class<?> customType) {
        this(entity, ordinal, id, type, name, isId, false, dbName, converterClass, customType);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, boolean isVirtual, @Nullable String dbName, @Nullable Class<? extends PropertyConverter> converterClass, @Nullable Class<?> customType) {
        this.entity = entity;
        this.ordinal = ordinal;
        this.id = id;
        this.type = type;
        this.name = name;
        this.isId = isId;
        this.isVirtual = isVirtual;
        this.dbName = dbName;
        this.converterClass = converterClass;
        this.customType = customType;
    }

    public PropertyQueryCondition<ENTITY> isNull() {
        return new PropertyQueryConditionImpl.NullCondition(this, PropertyQueryConditionImpl.NullCondition.Operation.IS_NULL);
    }

    public PropertyQueryCondition<ENTITY> notNull() {
        return new PropertyQueryConditionImpl.NullCondition(this, PropertyQueryConditionImpl.NullCondition.Operation.NOT_NULL);
    }

    public PropertyQueryCondition<ENTITY> equal(boolean value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(boolean value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.NOT_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> equal(short value) {
        return this.equal((long)value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(short value) {
        return this.notEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> greater(short value) {
        return this.greater((long)value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(short value) {
        return this.greaterOrEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> less(short value) {
        return this.less((long)value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(short value) {
        return this.lessOrEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> between(short lowerBoundary, short upperBoundary) {
        return this.between((long)lowerBoundary, (long)upperBoundary);
    }

    public PropertyQueryCondition<ENTITY> equal(int value) {
        return this.equal((long)value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(int value) {
        return this.notEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> greater(int value) {
        return this.greater((long)value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(int value) {
        return this.greaterOrEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> less(int value) {
        return this.less((long)value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(int value) {
        return this.lessOrEqual((long)value);
    }

    public PropertyQueryCondition<ENTITY> between(int lowerBoundary, int upperBoundary) {
        return this.between((long)lowerBoundary, (long)upperBoundary);
    }

    public PropertyQueryCondition<ENTITY> oneOf(int[] values) {
        return new PropertyQueryConditionImpl.IntArrayCondition(this, PropertyQueryConditionImpl.IntArrayCondition.Operation.IN, values);
    }

    public PropertyQueryCondition<ENTITY> notOneOf(int[] values) {
        return new PropertyQueryConditionImpl.IntArrayCondition(this, PropertyQueryConditionImpl.IntArrayCondition.Operation.NOT_IN, values);
    }

    public PropertyQueryCondition<ENTITY> equal(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.NOT_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> greater(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.GREATER, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.GREATER_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> less(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.LESS, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(long value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.LESS_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> between(long lowerBoundary, long upperBoundary) {
        return new PropertyQueryConditionImpl.LongLongCondition(this, PropertyQueryConditionImpl.LongLongCondition.Operation.BETWEEN, lowerBoundary, upperBoundary);
    }

    public PropertyQueryCondition<ENTITY> oneOf(long[] values) {
        return new PropertyQueryConditionImpl.LongArrayCondition(this, PropertyQueryConditionImpl.LongArrayCondition.Operation.IN, values);
    }

    public PropertyQueryCondition<ENTITY> notOneOf(long[] values) {
        return new PropertyQueryConditionImpl.LongArrayCondition(this, PropertyQueryConditionImpl.LongArrayCondition.Operation.NOT_IN, values);
    }

    public PropertyQueryCondition<ENTITY> equal(double value, double tolerance) {
        return new PropertyQueryConditionImpl.DoubleDoubleCondition(this, PropertyQueryConditionImpl.DoubleDoubleCondition.Operation.BETWEEN, value - tolerance, value + tolerance);
    }

    public PropertyQueryCondition<ENTITY> greater(double value) {
        return new PropertyQueryConditionImpl.DoubleCondition(this, PropertyQueryConditionImpl.DoubleCondition.Operation.GREATER, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(double value) {
        return new PropertyQueryConditionImpl.DoubleCondition(this, PropertyQueryConditionImpl.DoubleCondition.Operation.GREATER_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> less(double value) {
        return new PropertyQueryConditionImpl.DoubleCondition(this, PropertyQueryConditionImpl.DoubleCondition.Operation.LESS, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(double value) {
        return new PropertyQueryConditionImpl.DoubleCondition(this, PropertyQueryConditionImpl.DoubleCondition.Operation.LESS_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> between(double lowerBoundary, double upperBoundary) {
        return new PropertyQueryConditionImpl.DoubleDoubleCondition(this, PropertyQueryConditionImpl.DoubleDoubleCondition.Operation.BETWEEN, lowerBoundary, upperBoundary);
    }

    public PropertyQueryCondition<ENTITY> nearestNeighbors(float[] queryVector, int maxResultCount) {
        return new PropertyQueryConditionImpl.NearestNeighborCondition(this, queryVector, maxResultCount);
    }

    public PropertyQueryCondition<ENTITY> equal(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.NOT_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> greater(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.GREATER, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.GREATER_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> less(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.LESS, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(Date value) {
        return new PropertyQueryConditionImpl.LongCondition(this, PropertyQueryConditionImpl.LongCondition.Operation.LESS_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> oneOf(Date[] value) {
        return new PropertyQueryConditionImpl.LongArrayCondition(this, PropertyQueryConditionImpl.LongArrayCondition.Operation.IN, value);
    }

    public PropertyQueryCondition<ENTITY> notOneOf(Date[] value) {
        return new PropertyQueryConditionImpl.LongArrayCondition(this, PropertyQueryConditionImpl.LongArrayCondition.Operation.NOT_IN, value);
    }

    public PropertyQueryCondition<ENTITY> between(Date lowerBoundary, Date upperBoundary) {
        return new PropertyQueryConditionImpl.LongLongCondition(this, PropertyQueryConditionImpl.LongLongCondition.Operation.BETWEEN, lowerBoundary, upperBoundary);
    }

    public PropertyQueryCondition<ENTITY> equal(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> equal(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.EQUAL, value, order);
    }

    public PropertyQueryCondition<ENTITY> notEqual(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.NOT_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> notEqual(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.NOT_EQUAL, value, order);
    }

    public PropertyQueryCondition<ENTITY> greater(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.GREATER, value);
    }

    public PropertyQueryCondition<ENTITY> greater(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.GREATER, value, order);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.GREATER_OR_EQUAL, value, order);
    }

    public PropertyQueryCondition<ENTITY> less(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.LESS, value);
    }

    public PropertyQueryCondition<ENTITY> less(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.LESS, value, order);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.LESS_OR_EQUAL, value, order);
    }

    public PropertyQueryCondition<ENTITY> contains(String value) {
        this.checkNotStringArray();
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.CONTAINS, value);
    }

    public PropertyQueryCondition<ENTITY> contains(String value, QueryBuilder.StringOrder order) {
        this.checkNotStringArray();
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.CONTAINS, value, order);
    }

    private void checkNotStringArray() {
        if (String[].class == this.type) {
            throw new IllegalArgumentException("For a String[] property use containsElement() instead.");
        }
    }

    public PropertyQueryCondition<ENTITY> containsElement(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.CONTAINS_ELEMENT, value);
    }

    public PropertyQueryCondition<ENTITY> containsElement(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.CONTAINS_ELEMENT, value, order);
    }

    @Deprecated
    public PropertyQueryCondition<ENTITY> containsKeyValue(String key, String value) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.EQUAL_KEY_VALUE, key, value, QueryBuilder.StringOrder.CASE_SENSITIVE);
    }

    @Deprecated
    public PropertyQueryCondition<ENTITY> containsKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.EQUAL_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> equalKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.EQUAL_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> greaterKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.GREATER_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqualKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.GREATER_EQUALS_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> lessKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.LESS_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqualKeyValue(String key, String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringStringCondition(this, PropertyQueryConditionImpl.StringStringCondition.Operation.LESS_EQUALS_KEY_VALUE, key, value, order);
    }

    public PropertyQueryCondition<ENTITY> equalKeyValue(String key, long value) {
        return new PropertyQueryConditionImpl.StringLongCondition(this, PropertyQueryConditionImpl.StringLongCondition.Operation.EQUAL_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> greaterKeyValue(String key, long value) {
        return new PropertyQueryConditionImpl.StringLongCondition(this, PropertyQueryConditionImpl.StringLongCondition.Operation.GREATER_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqualKeyValue(String key, long value) {
        return new PropertyQueryConditionImpl.StringLongCondition(this, PropertyQueryConditionImpl.StringLongCondition.Operation.GREATER_EQUALS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> lessKeyValue(String key, long value) {
        return new PropertyQueryConditionImpl.StringLongCondition(this, PropertyQueryConditionImpl.StringLongCondition.Operation.LESS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqualKeyValue(String key, long value) {
        return new PropertyQueryConditionImpl.StringLongCondition(this, PropertyQueryConditionImpl.StringLongCondition.Operation.LESS_EQUALS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> equalKeyValue(String key, double value) {
        return new PropertyQueryConditionImpl.StringDoubleCondition(this, PropertyQueryConditionImpl.StringDoubleCondition.Operation.EQUAL_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> greaterKeyValue(String key, double value) {
        return new PropertyQueryConditionImpl.StringDoubleCondition(this, PropertyQueryConditionImpl.StringDoubleCondition.Operation.GREATER_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqualKeyValue(String key, double value) {
        return new PropertyQueryConditionImpl.StringDoubleCondition(this, PropertyQueryConditionImpl.StringDoubleCondition.Operation.GREATER_EQUALS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> lessKeyValue(String key, double value) {
        return new PropertyQueryConditionImpl.StringDoubleCondition(this, PropertyQueryConditionImpl.StringDoubleCondition.Operation.LESS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqualKeyValue(String key, double value) {
        return new PropertyQueryConditionImpl.StringDoubleCondition(this, PropertyQueryConditionImpl.StringDoubleCondition.Operation.LESS_EQUALS_KEY_VALUE, key, value);
    }

    public PropertyQueryCondition<ENTITY> startsWith(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.STARTS_WITH, value);
    }

    public PropertyQueryCondition<ENTITY> startsWith(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.STARTS_WITH, value, order);
    }

    public PropertyQueryCondition<ENTITY> endsWith(String value) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.ENDS_WITH, value);
    }

    public PropertyQueryCondition<ENTITY> endsWith(String value, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringCondition(this, PropertyQueryConditionImpl.StringCondition.Operation.ENDS_WITH, value, order);
    }

    public PropertyQueryCondition<ENTITY> oneOf(String[] values) {
        return new PropertyQueryConditionImpl.StringArrayCondition(this, PropertyQueryConditionImpl.StringArrayCondition.Operation.IN, values);
    }

    public PropertyQueryCondition<ENTITY> oneOf(String[] values, QueryBuilder.StringOrder order) {
        return new PropertyQueryConditionImpl.StringArrayCondition(this, PropertyQueryConditionImpl.StringArrayCondition.Operation.IN, values, order);
    }

    public PropertyQueryCondition<ENTITY> equal(byte[] value) {
        return new PropertyQueryConditionImpl.ByteArrayCondition(this, PropertyQueryConditionImpl.ByteArrayCondition.Operation.EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> greater(byte[] value) {
        return new PropertyQueryConditionImpl.ByteArrayCondition(this, PropertyQueryConditionImpl.ByteArrayCondition.Operation.GREATER, value);
    }

    public PropertyQueryCondition<ENTITY> greaterOrEqual(byte[] value) {
        return new PropertyQueryConditionImpl.ByteArrayCondition(this, PropertyQueryConditionImpl.ByteArrayCondition.Operation.GREATER_OR_EQUAL, value);
    }

    public PropertyQueryCondition<ENTITY> less(byte[] value) {
        return new PropertyQueryConditionImpl.ByteArrayCondition(this, PropertyQueryConditionImpl.ByteArrayCondition.Operation.LESS, value);
    }

    public PropertyQueryCondition<ENTITY> lessOrEqual(byte[] value) {
        return new PropertyQueryConditionImpl.ByteArrayCondition(this, PropertyQueryConditionImpl.ByteArrayCondition.Operation.LESS_OR_EQUAL, value);
    }

    @Internal
    public int getEntityId() {
        return this.entity.getEntityId();
    }

    @Internal
    public int getId() {
        if (this.id <= 0) {
            throw new IllegalStateException("Illegal property ID " + this.id + " for " + this);
        }
        return this.id;
    }

    boolean isIdVerified() {
        return this.idVerified;
    }

    void verifyId(int idInDb) {
        if (this.id <= 0) {
            throw new IllegalStateException("Illegal property ID " + this.id + " for " + this);
        }
        if (this.id != idInDb) {
            throw new DbException(this + " does not match ID in DB: " + idInDb);
        }
        this.idVerified = true;
    }

    public String toString() {
        return "Property \"" + this.name + "\" (ID: " + this.id + ")";
    }
}

