/*
 * Copyright 2025 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.config;

/**
 * Options flags for trees.
 */
@SuppressWarnings("unused")
public final class TreeOptionFlags {
  private TreeOptionFlags() { }
  /**
   * If true, debug logs are always disabled for this tree regardless of the store's debug flags.
   */
  public static final int DebugLogsDisable = 1;
  /**
   * If true, debug logs are always enabled for this tree regardless of the store's debug flags.
   */
  public static final int DebugLogsEnable = 2;
  /**
   * By default, a path such as "a/b/c" can address a branch and a leaf at the same time.
   * E.g. under the common parent path "a/b", a branch "c" and a "c" leaf may exist.
   * To disable this, set this flag to true.
   * This will enable an additional check when inserting new leafs and new branches for the existence of the other.
   */
  public static final int EnforceUniquePath = 4;
  /**
   * In some scenarios, e.g. when using Sync, multiple node objects of the same type (e.g. branch or leaf) at the
   * same path may exist temporarily. By enabling this flag, this is not considered an error situation. Instead, the
   * first node is picked.
   */
  public static final int AllowNonUniqueNodes = 8;
  /**
   * Nodes described in AllowNonUniqueNodes will be automatically detected to consolidate them (manually).
   */
  public static final int DetectNonUniqueNodes = 16;
  /**
   * Nodes described in AllowNonUniqueNodes will be automatically consolidated to make them unique.
   * This consolidation happens e.g. on put/remove operations.
   * Using this value implies DetectNonUniqueNodes.
   */
  public static final int AutoConsolidateNonUniqueNodes = 32;
}

