/*
 * Copyright 2023 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox;

/**
 * Debug flags typically enable additional "debug logging" that can be helpful to better understand what is going on
 * internally. These are intended for the development process only; typically one does not enable them for releases.
 *
 * @deprecated DebugFlags moved to config package: use {@link io.objectbox.config.DebugFlags} instead.
 */
@SuppressWarnings("unused")
@Deprecated
public final class DebugFlags {
  private DebugFlags() { }
  public static final int LOG_TRANSACTIONS_READ = 1;
  public static final int LOG_TRANSACTIONS_WRITE = 2;
  public static final int LOG_QUERIES = 4;
  public static final int LOG_QUERY_PARAMETERS = 8;
  public static final int LOG_ASYNC_QUEUE = 16;
  public static final int LOG_CACHE_HITS = 32;
  public static final int LOG_CACHE_ALL = 64;
  public static final int LOG_TREE = 128;
  /**
   * For a limited number of error conditions, this will try to print stack traces.
   * Note: this is Linux-only, experimental, and has several limitations:
   * The usefulness of these stack traces depends on several factors and might not be helpful at all.
   */
  public static final int LOG_EXCEPTION_STACK_TRACE = 256;
  /**
   * Run a quick self-test to verify basic threading; somewhat paranoia to check the platform and the library setup.
   */
  public static final int RUN_THREADING_SELF_TEST = 512;
}

