/*
 * Copyright 2025 ObjectBox Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

/**
 * A property type of an external system (e.g. another database) that has no default mapping to an ObjectBox type.
 * External property types numeric values start at 100 to avoid overlaps with ObjectBox's PropertyType.
 * (And if we ever support one of these as a primary type, we could share the numeric value?)
 */
@SuppressWarnings("unused")
public final class ExternalPropertyType {
  private ExternalPropertyType() { }
  /**
   * Not a real type: represents uninitialized state and can be used for forward compatibility.
   */
  public static final short Unknown = 0;
  /**
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation, little endian (16 bytes)
   */
  public static final short Int128 = 100;
  public static final short Reserved1 = 101;
  /**
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (16 bytes)
   */
  public static final short Uuid = 102;
  /**
   * IEEE 754 decimal128 type, e.g. supported by MongoDB
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (16 bytes)
   */
  public static final short Decimal128 = 103;
  public static final short Reserved2 = 104;
  public static final short Reserved3 = 105;
  public static final short Reserved4 = 106;
  /**
   * A key/value map; e.g. corresponds to a JSON object or a MongoDB document (although not keeping the key order).
   * Unlike the Flex type, this must contain a map value (e.g. not a vector or a scalar).
   * Representing type: Flex
   * Encoding: Flex
   */
  public static final short FlexMap = 107;
  /**
   * A vector (aka list or array) of flexible elements; e.g. corresponds to a JSON array or a MongoDB array.
   * Unlike the Flex type, this must contain a vector value (e.g. not a map or a scalar).
   * Representing type: Flex
   * Encoding: Flex
   */
  public static final short FlexVector = 108;
  /**
   * Placeholder (not yet used) for a JSON document.
   * Representing type: String
   */
  public static final short Json = 109;
  /**
   * Placeholder (not yet used) for a BSON document.
   * Representing type: ByteVector
   */
  public static final short Bson = 110;
  /**
   * JavaScript source code
   * Representing type: String
   */
  public static final short JavaScript = 111;
  public static final short Reserved5 = 112;
  public static final short Reserved6 = 113;
  public static final short Reserved7 = 114;
  public static final short Reserved8 = 115;
  /**
   * A vector (array) of Int128 values
   */
  public static final short Int128Vector = 116;
  public static final short Reserved9 = 117;
  /**
   * A vector (array) of Int128 values
   */
  public static final short UuidVector = 118;
  public static final short Reserved10 = 119;
  public static final short Reserved11 = 120;
  public static final short Reserved12 = 121;
  public static final short Reserved13 = 122;
  /**
   * The 12-byte ObjectId type in MongoDB
   * Representing type: ByteVector
   * Encoding: 1:1 binary representation (12 bytes)
   */
  public static final short MongoId = 123;
  /**
   * A vector (array) of MongoId values
   */
  public static final short MongoIdVector = 124;
  /**
   * Representing type: Long
   * Encoding: Two unsigned 32-bit integers merged into a 64-bit integer.
   */
  public static final short MongoTimestamp = 125;
  /**
   * Representing type: ByteVector
   * Encoding: 3 zero bytes (reserved, functions as padding), fourth byte is the sub-type,
   * followed by the binary data.
   */
  public static final short MongoBinary = 126;
  /**
   * Representing type: string vector with 2 elements (index 0: pattern, index 1: options)
   * Encoding: 1:1 string representation
   */
  public static final short MongoRegex = 127;

  public static final String[] names = { "Unknown", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Int128", "Reserved1", "Uuid", "Decimal128", "Reserved2", "Reserved3", "Reserved4", "FlexMap", "FlexVector", "Json", "Bson", "JavaScript", "Reserved5", "Reserved6", "Reserved7", "Reserved8", "Int128Vector", "Reserved9", "UuidVector", "Reserved10", "Reserved11", "Reserved12", "Reserved13", "MongoId", "MongoIdVector", "MongoTimestamp", "MongoBinary", "MongoRegex", };

  public static String name(int e) { return names[e]; }
}

