/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html.tag;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.html.CssInlineStyleParser;
import io.noties.markwon.html.CssProperty;
import io.noties.markwon.html.tag.ImageHandler;
import io.noties.markwon.image.ImageSize;
import java.util.Map;

class ImageSizeParserImpl
implements ImageHandler.ImageSizeParser {
    private final CssInlineStyleParser inlineStyleParser;

    ImageSizeParserImpl(@NonNull CssInlineStyleParser inlineStyleParser) {
        this.inlineStyleParser = inlineStyleParser;
    }

    @Override
    public ImageSize parse(@NonNull Map<String, String> attributes) {
        ImageSize.Dimension width = null;
        ImageSize.Dimension height = null;
        String style = attributes.get("style");
        if (!TextUtils.isEmpty((CharSequence)style)) {
            for (CssProperty cssProperty : this.inlineStyleParser.parse(style)) {
                String key = cssProperty.key();
                if ("width".equals(key)) {
                    width = this.dimension(cssProperty.value());
                } else if ("height".equals(key)) {
                    height = this.dimension(cssProperty.value());
                }
                if (width == null || height == null) continue;
                break;
            }
        }
        if (width != null && height != null) {
            return new ImageSize(width, height);
        }
        if (width == null) {
            width = this.dimension(attributes.get("width"));
        }
        if (height == null) {
            height = this.dimension(attributes.get("height"));
        }
        if (width == null && height == null) {
            return null;
        }
        return new ImageSize(width, height);
    }

    @Nullable
    @VisibleForTesting
    ImageSize.Dimension dimension(@Nullable String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        int length = value.length();
        for (int i = length - 1; i > -1; --i) {
            if (!Character.isDigit(value.charAt(i))) continue;
            try {
                float val = Float.parseFloat(value.substring(0, i + 1));
                String unit = i == length - 1 ? null : value.substring(i + 1, length);
                return new ImageSize.Dimension(val, unit);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

