/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html.tag;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.html.CssInlineStyleParser;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.tag.ImageSizeParserImpl;
import io.noties.markwon.html.tag.SimpleTagHandler;
import io.noties.markwon.image.ImageProps;
import io.noties.markwon.image.ImageSize;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.commonmark.node.Image;

public class ImageHandler
extends SimpleTagHandler {
    private final ImageSizeParser imageSizeParser;

    @Override
    @NonNull
    public Collection<String> supportedTags() {
        return Collections.singleton("img");
    }

    @NonNull
    public static ImageHandler create() {
        return new ImageHandler(new ImageSizeParserImpl(CssInlineStyleParser.create()));
    }

    ImageHandler(@NonNull ImageSizeParser imageSizeParser) {
        this.imageSizeParser = imageSizeParser;
    }

    @Override
    @Nullable
    public Object getSpans(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps renderProps, @NonNull HtmlTag tag) {
        Map<String, String> attributes = tag.attributes();
        String src = attributes.get("src");
        if (TextUtils.isEmpty((CharSequence)src)) {
            return null;
        }
        SpanFactory spanFactory = configuration.spansFactory().get(Image.class);
        if (spanFactory == null) {
            return null;
        }
        String destination = configuration.imageDestinationProcessor().process(src);
        ImageSize imageSize = this.imageSizeParser.parse(tag.attributes());
        ImageProps.DESTINATION.set(renderProps, (Object)destination);
        ImageProps.IMAGE_SIZE.set(renderProps, (Object)imageSize);
        ImageProps.REPLACEMENT_TEXT_IS_LINK.set(renderProps, (Object)false);
        return spanFactory.getSpans(configuration, renderProps);
    }

    static interface ImageSizeParser {
        @Nullable
        public ImageSize parse(@NonNull Map<String, String> var1);
    }
}

