/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.html.AppendableUtils;
import io.noties.markwon.html.HtmlEmptyTagReplacement;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.HtmlTagImpl;
import io.noties.markwon.html.MarkwonHtmlParser;
import io.noties.markwon.html.TrimmingAppender;
import io.noties.markwon.html.jsoup.nodes.Attribute;
import io.noties.markwon.html.jsoup.nodes.Attributes;
import io.noties.markwon.html.jsoup.parser.CharacterReader;
import io.noties.markwon.html.jsoup.parser.ParseErrorList;
import io.noties.markwon.html.jsoup.parser.Token;
import io.noties.markwon.html.jsoup.parser.Tokeniser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MarkwonHtmlParserImpl
extends MarkwonHtmlParser {
    @VisibleForTesting
    static final Set<String> INLINE_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "dfn", "em", "i", "img", "input", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "time", "tt", "var")));
    private static final Set<String> VOID_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr")));
    private static final Set<String> BLOCK_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("address", "article", "aside", "blockquote", "canvas", "dd", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "main", "nav", "noscript", "ol", "output", "p", "pre", "section", "table", "tfoot", "ul", "video")));
    private static final String TAG_PARAGRAPH = "p";
    private static final String TAG_LIST_ITEM = "li";
    private final HtmlEmptyTagReplacement emptyTagReplacement;
    private final TrimmingAppender trimmingAppender;
    private final List<HtmlTagImpl.InlineImpl> inlineTags = new ArrayList<HtmlTagImpl.InlineImpl>(0);
    private HtmlTagImpl.BlockImpl currentBlock = HtmlTagImpl.BlockImpl.root();
    private boolean isInsidePreTag;
    private boolean previousIsBlock;

    @NonNull
    public static MarkwonHtmlParserImpl create() {
        return MarkwonHtmlParserImpl.create(HtmlEmptyTagReplacement.create());
    }

    @NonNull
    public static MarkwonHtmlParserImpl create(@NonNull HtmlEmptyTagReplacement inlineTagReplacement) {
        return new MarkwonHtmlParserImpl(inlineTagReplacement, TrimmingAppender.create());
    }

    MarkwonHtmlParserImpl(@NonNull HtmlEmptyTagReplacement replacement, @NonNull TrimmingAppender trimmingAppender) {
        this.emptyTagReplacement = replacement;
        this.trimmingAppender = trimmingAppender;
    }

    @Override
    public <T extends Appendable & CharSequence> void processFragment(@NonNull T output, @NonNull String htmlFragment) {
        Tokeniser tokeniser = new Tokeniser(new CharacterReader(htmlFragment), ParseErrorList.noTracking());
        while (true) {
            Token token = tokeniser.read();
            Token.TokenType tokenType = token.type;
            if (Token.TokenType.EOF == tokenType) break;
            switch (tokenType) {
                case StartTag: {
                    Token.StartTag startTag = (Token.StartTag)token;
                    if (MarkwonHtmlParserImpl.isInlineTag(startTag.normalName)) {
                        this.processInlineTagStart(output, startTag);
                        break;
                    }
                    this.processBlockTagStart(output, startTag);
                    break;
                }
                case EndTag: {
                    Token.EndTag endTag = (Token.EndTag)token;
                    if (MarkwonHtmlParserImpl.isInlineTag(endTag.normalName)) {
                        this.processInlineTagEnd(output, endTag);
                        break;
                    }
                    this.processBlockTagEnd(output, endTag);
                    break;
                }
                case Character: {
                    this.processCharacter(output, (Token.Character)token);
                }
            }
            token.reset();
        }
    }

    @Override
    public void flushInlineTags(int documentLength, @NonNull MarkwonHtmlParser.FlushAction<HtmlTag.Inline> action) {
        if (this.inlineTags.size() > 0) {
            if (documentLength > -1) {
                for (HtmlTagImpl.InlineImpl inline : this.inlineTags) {
                    inline.closeAt(documentLength);
                }
            }
            action.apply(Collections.unmodifiableList(this.inlineTags));
            this.inlineTags.clear();
        } else {
            action.apply(Collections.emptyList());
        }
    }

    @Override
    public void flushBlockTags(int documentLength, @NonNull MarkwonHtmlParser.FlushAction<HtmlTag.Block> action) {
        List<HtmlTag.Block> children;
        HtmlTagImpl.BlockImpl block = this.currentBlock;
        while (block.parent != null) {
            block = block.parent;
        }
        if (documentLength > -1) {
            block.closeAt(documentLength);
        }
        if ((children = block.children()).size() > 0) {
            action.apply(children);
        } else {
            action.apply(Collections.emptyList());
        }
        this.currentBlock = HtmlTagImpl.BlockImpl.root();
    }

    @Override
    public void reset() {
        this.inlineTags.clear();
        this.currentBlock = HtmlTagImpl.BlockImpl.root();
    }

    protected <T extends Appendable & CharSequence> void processInlineTagStart(@NonNull T output, @NonNull Token.StartTag startTag) {
        String name = startTag.normalName;
        HtmlTagImpl.InlineImpl inline = new HtmlTagImpl.InlineImpl(name, ((CharSequence)output).length(), MarkwonHtmlParserImpl.extractAttributes(startTag));
        this.ensureNewLineIfPreviousWasBlock(output);
        if (MarkwonHtmlParserImpl.isVoidTag(name) || startTag.selfClosing) {
            String replacement = this.emptyTagReplacement.replace(inline);
            if (replacement != null && replacement.length() > 0) {
                AppendableUtils.appendQuietly(output, replacement);
            }
            inline.closeAt(((CharSequence)output).length());
        }
        this.inlineTags.add(inline);
    }

    protected <T extends Appendable & CharSequence> void processInlineTagEnd(@NonNull T output, @NonNull Token.EndTag endTag) {
        HtmlTagImpl.InlineImpl openInline = this.findOpenInlineTag(endTag.normalName);
        if (openInline != null) {
            if (MarkwonHtmlParserImpl.isEmpty(output, openInline)) {
                this.appendEmptyTagReplacement(output, openInline);
            }
            openInline.closeAt(((CharSequence)output).length());
        }
    }

    protected <T extends Appendable & CharSequence> void processBlockTagStart(@NonNull T output, @NonNull Token.StartTag startTag) {
        boolean isVoid;
        String name = startTag.normalName;
        if (TAG_PARAGRAPH.equals(this.currentBlock.name)) {
            this.currentBlock.closeAt(((CharSequence)output).length());
            AppendableUtils.appendQuietly(output, '\n');
            this.currentBlock = this.currentBlock.parent;
        } else if (TAG_LIST_ITEM.equals(name) && TAG_LIST_ITEM.equals(this.currentBlock.name)) {
            this.currentBlock.closeAt(((CharSequence)output).length());
            this.currentBlock = this.currentBlock.parent;
        }
        if (MarkwonHtmlParserImpl.isBlockTag(name)) {
            this.isInsidePreTag = "pre".equals(name);
            MarkwonHtmlParserImpl.ensureNewLine(output);
        } else {
            this.ensureNewLineIfPreviousWasBlock(output);
        }
        int start = ((CharSequence)output).length();
        HtmlTagImpl.BlockImpl block = HtmlTagImpl.BlockImpl.create(name, start, MarkwonHtmlParserImpl.extractAttributes(startTag), this.currentBlock);
        boolean bl = isVoid = MarkwonHtmlParserImpl.isVoidTag(name) || startTag.selfClosing;
        if (isVoid) {
            String replacement = this.emptyTagReplacement.replace(block);
            if (replacement != null && replacement.length() > 0) {
                AppendableUtils.appendQuietly(output, replacement);
            }
            block.closeAt(((CharSequence)output).length());
        }
        this.appendBlockChild(block.parent, block);
        if (!isVoid) {
            this.currentBlock = block;
        }
    }

    protected <T extends Appendable & CharSequence> void processBlockTagEnd(@NonNull T output, @NonNull Token.EndTag endTag) {
        String name = endTag.normalName;
        HtmlTagImpl.BlockImpl block = this.findOpenBlockTag(endTag.normalName);
        if (block != null) {
            if ("pre".equals(name)) {
                this.isInsidePreTag = false;
            }
            if (MarkwonHtmlParserImpl.isEmpty(output, block)) {
                this.appendEmptyTagReplacement(output, block);
            }
            block.closeAt(((CharSequence)output).length());
            if (!block.isEmpty()) {
                this.previousIsBlock = MarkwonHtmlParserImpl.isBlockTag(block.name);
            }
            if (TAG_PARAGRAPH.equals(name)) {
                AppendableUtils.appendQuietly(output, '\n');
            }
            this.currentBlock = block.parent;
        }
    }

    protected <T extends Appendable & CharSequence> void processCharacter(@NonNull T output, @NonNull Token.Character character) {
        if (this.isInsidePreTag) {
            AppendableUtils.appendQuietly(output, character.getData());
        } else {
            this.ensureNewLineIfPreviousWasBlock(output);
            this.trimmingAppender.append(output, character.getData());
        }
    }

    protected void appendBlockChild(@NonNull HtmlTagImpl.BlockImpl parent, @NonNull HtmlTagImpl.BlockImpl child) {
        List<HtmlTagImpl.BlockImpl> children = parent.children;
        if (children == null) {
            parent.children = children = new ArrayList<HtmlTagImpl.BlockImpl>(2);
        }
        children.add(child);
    }

    @Nullable
    protected HtmlTagImpl.InlineImpl findOpenInlineTag(@NonNull String name) {
        for (int i = this.inlineTags.size() - 1; i > -1; --i) {
            HtmlTagImpl.InlineImpl inline = this.inlineTags.get(i);
            if (!name.equals(inline.name) || inline.end >= 0) continue;
            return inline;
        }
        return null;
    }

    @Nullable
    protected HtmlTagImpl.BlockImpl findOpenBlockTag(@NonNull String name) {
        HtmlTagImpl.BlockImpl blockTag = this.currentBlock;
        while (blockTag != null && !name.equals(blockTag.name) && !blockTag.isClosed()) {
            blockTag = blockTag.parent;
        }
        return blockTag;
    }

    protected <T extends Appendable & CharSequence> void ensureNewLineIfPreviousWasBlock(@NonNull T output) {
        if (this.previousIsBlock) {
            MarkwonHtmlParserImpl.ensureNewLine(output);
            this.previousIsBlock = false;
        }
    }

    protected static boolean isInlineTag(@NonNull String name) {
        return INLINE_TAGS.contains(name);
    }

    protected static boolean isVoidTag(@NonNull String name) {
        return VOID_TAGS.contains(name);
    }

    protected static boolean isBlockTag(@NonNull String name) {
        return BLOCK_TAGS.contains(name);
    }

    protected static <T extends Appendable & CharSequence> void ensureNewLine(@NonNull T output) {
        int length = ((CharSequence)output).length();
        if (length > 0 && '\n' != ((CharSequence)output).charAt(length - 1)) {
            AppendableUtils.appendQuietly(output, '\n');
        }
    }

    @NonNull
    protected static Map<String, String> extractAttributes(@NonNull Token.StartTag startTag) {
        Map<String, String> map;
        Attributes attributes = startTag.attributes;
        int size = attributes.size();
        if (size > 0) {
            map = new HashMap<String, String>(size);
            for (Attribute attribute : attributes) {
                map.put(attribute.getKey().toLowerCase(Locale.US), attribute.getValue());
            }
            map = Collections.unmodifiableMap(map);
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    protected static <T extends Appendable & CharSequence> boolean isEmpty(@NonNull T output, @NonNull HtmlTagImpl tag) {
        return tag.start == ((CharSequence)output).length();
    }

    protected <T extends Appendable & CharSequence> void appendEmptyTagReplacement(@NonNull T output, @NonNull HtmlTagImpl tag) {
        String replacement = this.emptyTagReplacement.replace(tag);
        if (replacement != null) {
            AppendableUtils.appendQuietly(output, replacement);
        }
    }
}

