/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.html.CssProperty;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CssInlineStyleParser {
    @NonNull
    public abstract Iterable<CssProperty> parse(@NonNull String var1);

    @NonNull
    public static CssInlineStyleParser create() {
        return new Impl();
    }

    static class Impl
    extends CssInlineStyleParser {
        Impl() {
        }

        @Override
        @NonNull
        public Iterable<CssProperty> parse(@NonNull String inlineStyle) {
            return new CssIterable(inlineStyle);
        }

        private static class CssIterable
        implements Iterable<CssProperty> {
            private final String input;

            CssIterable(@NonNull String input) {
                this.input = input;
            }

            @Override
            @NonNull
            public Iterator<CssProperty> iterator() {
                return new CssIterator();
            }

            private class CssIterator
            implements Iterator<CssProperty> {
                private final CssProperty cssProperty = new CssProperty();
                private final StringBuilder builder = new StringBuilder();
                private final int length = CssIterable.access$100(CssIterable.this).length();
                private int index;

                private CssIterator() {
                }

                @Override
                public boolean hasNext() {
                    this.prepareNext();
                    return this.hasNextPrepared();
                }

                @Override
                public CssProperty next() {
                    if (!this.hasNextPrepared()) {
                        throw new NoSuchElementException();
                    }
                    return this.cssProperty;
                }

                private void prepareNext() {
                    this.cssProperty.set("", "");
                    this.builder.setLength(0);
                    String key = null;
                    String value = null;
                    boolean keyHasWhiteSpace = false;
                    for (int i = this.index; i < this.length; ++i) {
                        char c = CssIterable.this.input.charAt(i);
                        if (key == null) {
                            if (':' == c) {
                                if (this.builder.length() > 0) {
                                    key = this.builder.toString().trim();
                                }
                                this.builder.setLength(0);
                                continue;
                            }
                            if (';' == c) {
                                this.builder.setLength(0);
                                continue;
                            }
                            if (Character.isWhitespace(c)) {
                                if (this.builder.length() <= 0) continue;
                                keyHasWhiteSpace = true;
                                continue;
                            }
                            if (keyHasWhiteSpace) {
                                this.builder.setLength(0);
                                this.builder.append(c);
                                keyHasWhiteSpace = false;
                                continue;
                            }
                            this.builder.append(c);
                            continue;
                        }
                        if (value != null) continue;
                        if (Character.isWhitespace(c)) {
                            if (this.builder.length() <= 0) continue;
                            this.builder.append(c);
                            continue;
                        }
                        if (';' == c) {
                            value = this.builder.toString().trim();
                            this.builder.setLength(0);
                            if (!this.hasValues(key, value)) continue;
                            this.index = i + 1;
                            this.cssProperty.set(key, value);
                            return;
                        }
                        this.builder.append(c);
                    }
                    if (key != null && this.builder.length() > 0) {
                        value = this.builder.toString().trim();
                        this.cssProperty.set(key, value);
                        this.index = this.length;
                    }
                }

                private boolean hasNextPrepared() {
                    return this.hasValues(this.cssProperty.key(), this.cssProperty.value());
                }

                private boolean hasValues(@Nullable String key, @Nullable String value) {
                    return !TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value);
                }
            }
        }
    }
}

