/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tables;

import android.content.Context;
import android.graphics.Paint;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import io.noties.markwon.utils.ColorUtils;
import io.noties.markwon.utils.Dip;

public class TableTheme {
    protected static final int TABLE_BORDER_DEF_ALPHA = 75;
    protected static final int TABLE_ODD_ROW_DEF_ALPHA = 22;
    protected final int tableCellPadding;
    protected final int tableBorderColor;
    protected final int tableBorderWidth;
    protected final int tableOddRowBackgroundColor;
    protected final int tableEvenRowBackgroundColor;
    protected final int tableHeaderRowBackgroundColor;

    @NonNull
    public static TableTheme create(@NonNull Context context) {
        return TableTheme.buildWithDefaults(context).build();
    }

    @NonNull
    public static Builder buildWithDefaults(@NonNull Context context) {
        Dip dip = Dip.create((Context)context);
        return TableTheme.emptyBuilder().tableCellPadding(dip.toPx(4)).tableBorderWidth(dip.toPx(1));
    }

    @NonNull
    public static Builder emptyBuilder() {
        return new Builder();
    }

    protected TableTheme(@NonNull Builder builder) {
        this.tableCellPadding = builder.tableCellPadding;
        this.tableBorderColor = builder.tableBorderColor;
        this.tableBorderWidth = builder.tableBorderWidth;
        this.tableOddRowBackgroundColor = builder.tableOddRowBackgroundColor;
        this.tableEvenRowBackgroundColor = builder.tableEvenRowBackgroundColor;
        this.tableHeaderRowBackgroundColor = builder.tableHeaderRowBackgroundColor;
    }

    @NonNull
    public Builder asBuilder() {
        return new Builder().tableCellPadding(this.tableCellPadding).tableBorderColor(this.tableBorderColor).tableBorderWidth(this.tableBorderWidth).tableOddRowBackgroundColor(this.tableOddRowBackgroundColor).tableEvenRowBackgroundColor(this.tableEvenRowBackgroundColor).tableHeaderRowBackgroundColor(this.tableHeaderRowBackgroundColor);
    }

    public int tableCellPadding() {
        return this.tableCellPadding;
    }

    public int tableBorderWidth(@NonNull Paint paint) {
        int out = this.tableBorderWidth == -1 ? (int)(paint.getStrokeWidth() + 0.5f) : this.tableBorderWidth;
        return out;
    }

    public void applyTableBorderStyle(@NonNull Paint paint) {
        int color = this.tableBorderColor == 0 ? ColorUtils.applyAlpha((int)paint.getColor(), (int)75) : this.tableBorderColor;
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
    }

    public void applyTableOddRowStyle(@NonNull Paint paint) {
        int color = this.tableOddRowBackgroundColor == 0 ? ColorUtils.applyAlpha((int)paint.getColor(), (int)22) : this.tableOddRowBackgroundColor;
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
    }

    public void applyTableEvenRowStyle(@NonNull Paint paint) {
        paint.setColor(this.tableEvenRowBackgroundColor);
        paint.setStyle(Paint.Style.FILL);
    }

    public void applyTableHeaderRowStyle(@NonNull Paint paint) {
        paint.setColor(this.tableHeaderRowBackgroundColor);
        paint.setStyle(Paint.Style.FILL);
    }

    public static class Builder {
        private int tableCellPadding;
        private int tableBorderColor;
        private int tableBorderWidth = -1;
        private int tableOddRowBackgroundColor;
        private int tableEvenRowBackgroundColor;
        private int tableHeaderRowBackgroundColor;

        @NonNull
        public Builder tableCellPadding(@Px int tableCellPadding) {
            this.tableCellPadding = tableCellPadding;
            return this;
        }

        @NonNull
        public Builder tableBorderColor(@ColorInt int tableBorderColor) {
            this.tableBorderColor = tableBorderColor;
            return this;
        }

        @NonNull
        public Builder tableBorderWidth(@Px int tableBorderWidth) {
            this.tableBorderWidth = tableBorderWidth;
            return this;
        }

        @NonNull
        public Builder tableOddRowBackgroundColor(@ColorInt int tableOddRowBackgroundColor) {
            this.tableOddRowBackgroundColor = tableOddRowBackgroundColor;
            return this;
        }

        @NonNull
        public Builder tableEvenRowBackgroundColor(@ColorInt int tableEvenRowBackgroundColor) {
            this.tableEvenRowBackgroundColor = tableEvenRowBackgroundColor;
            return this;
        }

        @NonNull
        public Builder tableHeaderRowBackgroundColor(@ColorInt int tableHeaderRowBackgroundColor) {
            this.tableHeaderRowBackgroundColor = tableHeaderRowBackgroundColor;
            return this;
        }

        @NonNull
        public TableTheme build() {
            return new TableTheme(this);
        }
    }
}

