/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.Markwon;
import io.noties.markwon.editor.MarkwonEditor;
import io.noties.markwon.editor.PersistedSpans;
import io.noties.markwon.editor.diff_match_patch;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class MarkwonEditorImpl
extends MarkwonEditor {
    private final Markwon markwon;
    private final PersistedSpans.Provider persistedSpansProvider;
    private final Class<?> punctuationSpanType;
    @Nullable
    private final MarkwonEditor.SpansHandler spansHandler;

    MarkwonEditorImpl(@NonNull Markwon markwon, @NonNull PersistedSpans.Provider persistedSpansProvider, @NonNull Class<?> punctuationSpanType, @Nullable MarkwonEditor.SpansHandler spansHandler) {
        this.markwon = markwon;
        this.persistedSpansProvider = persistedSpansProvider;
        this.punctuationSpanType = punctuationSpanType;
        this.spansHandler = spansHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NonNull Editable editable) {
        String input = editable.toString();
        Spannable renderedMarkdown = (Spannable)this.markwon.toMarkdown(input);
        String markdown = renderedMarkdown.toString();
        MarkwonEditor.SpansHandler spansHandler = this.spansHandler;
        boolean hasAdditionalSpans = spansHandler != null;
        PersistedSpans persistedSpans = this.persistedSpansProvider.provide((Spannable)editable);
        try {
            LinkedList<diff_match_patch.Diff> diffs = diff_match_patch.diff_main(input, markdown);
            int inputLength = 0;
            int markdownLength = 0;
            block8: for (diff_match_patch.Diff diff : diffs) {
                switch (diff.operation) {
                    case DELETE: {
                        Object[] spans;
                        int start = inputLength;
                        editable.setSpan(persistedSpans.get(this.punctuationSpanType), start, inputLength += diff.text.length(), 33);
                        if (!hasAdditionalSpans) continue block8;
                        for (Object span : spans = renderedMarkdown.getSpans(markdownLength, markdownLength + 1, Object.class)) {
                            if (markdownLength != renderedMarkdown.getSpanStart(span)) continue;
                            spansHandler.handle(persistedSpans, editable, input, span, start, renderedMarkdown.getSpanEnd(span) - markdownLength);
                            renderedMarkdown.removeSpan(span);
                        }
                        continue block8;
                    }
                    case INSERT: {
                        markdownLength += diff.text.length();
                        break;
                    }
                    case EQUAL: {
                        Object[] spans;
                        int length = diff.text.length();
                        int inputStart = inputLength;
                        int markdownStart = markdownLength;
                        inputLength += length;
                        markdownLength += length;
                        if (!hasAdditionalSpans) continue block8;
                        for (Object span : spans = renderedMarkdown.getSpans(markdownStart, markdownLength, Object.class)) {
                            int end;
                            int spanStart = renderedMarkdown.getSpanStart(span);
                            if (spanStart < markdownStart || (end = renderedMarkdown.getSpanEnd(span)) > markdownLength) continue;
                            spansHandler.handle(persistedSpans, editable, input, span, inputStart + (spanStart - markdownStart), end - spanStart);
                            renderedMarkdown.removeSpan(span);
                        }
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        finally {
            persistedSpans.removeUnused();
        }
    }

    @Override
    public void preRender(@NonNull Editable editable, @NonNull MarkwonEditor.PreRenderResultListener listener) {
        final RecordingSpannableStringBuilder builder = new RecordingSpannableStringBuilder((CharSequence)editable);
        this.process((Editable)builder);
        listener.onPreRenderResult(new MarkwonEditor.PreRenderResult(){

            @Override
            @NonNull
            public Editable resultEditable() {
                return builder;
            }

            @Override
            public void dispatchTo(@NonNull Editable e) {
                for (Span span : builder.applied) {
                    e.setSpan(span.what, span.start, span.end, span.flags);
                }
                for (Object object : builder.removed) {
                    e.removeSpan(object);
                }
            }
        });
    }

    private static class RecordingSpannableStringBuilder
    extends SpannableStringBuilder {
        final List<Span> applied = new ArrayList<Span>(3);
        final List<Object> removed = new ArrayList<Object>(0);

        RecordingSpannableStringBuilder(CharSequence text) {
            super(text);
        }

        public void setSpan(Object what, int start, int end, int flags) {
            super.setSpan(what, start, end, flags);
            this.applied.add(new Span(what, start, end, flags));
        }

        public void removeSpan(Object what) {
            super.removeSpan(what);
            this.removed.add(what);
        }
    }

    private static class Span {
        final Object what;
        final int start;
        final int end;
        final int flags;

        Span(Object what, int start, int end, int flags) {
            this.what = what;
            this.start = start;
            this.end = end;
            this.flags = flags;
        }
    }
}

