/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.Iov;
import io.netty.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.StringJoiner;

final class SubmissionQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SubmissionQueue.class);
    private static final long SQE_SIZE = 64L;
    private static final int INT_SIZE = 4;
    private static final int SQE_OP_CODE_FIELD = 0;
    private static final int SQE_FLAGS_FIELD = 1;
    private static final int SQE_IOPRIO_FIELD = 2;
    private static final int SQE_FD_FIELD = 4;
    private static final int SQE_UNION1_FIELD = 8;
    private static final int SQE_UNION2_FIELD = 16;
    private static final int SQE_LEN_FIELD = 24;
    private static final int SQE_UNION3_FIELD = 28;
    private static final int SQE_USER_DATA_FIELD = 32;
    private static final int SQE_UNION4_FIELD = 40;
    private static final int SQE_PERSONALITY_FIELD = 42;
    private static final int SQE_UNION5_FIELD = 44;
    private static final int SQE_UNION6_FIELD = 48;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long kFlagsAddress;
    private final long kDroppedAddress;
    private final long kArrayAddress;
    final long submissionQueueArrayAddress;
    final int ringEntries;
    private final int ringMask;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    int enterRingFd;
    private int enterFlags;
    private int head;
    private int tail;

    SubmissionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kFlagsAddress, long kDroppedAddress, long kArrayAddress, long submissionQueueArrayAddress, int ringSize, long ringAddress, int ringFd) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.kFlagsAddress = kFlagsAddress;
        this.kDroppedAddress = kDroppedAddress;
        this.kArrayAddress = kArrayAddress;
        this.submissionQueueArrayAddress = submissionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.enterRingFd = ringFd;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.head = PlatformDependent.getIntVolatile((long)kHeadAddress);
        this.tail = PlatformDependent.getIntVolatile((long)kTailAddress);
        PlatformDependent.setMemory((long)submissionQueueArrayAddress, (long)((long)this.ringEntries * 64L), (byte)0);
        long address = kArrayAddress;
        int i = 0;
        while (i < this.ringEntries) {
            PlatformDependent.putInt((long)address, (int)i);
            ++i;
            address += 4L;
        }
    }

    void tryRegisterRingFd() {
        int enterFlags;
        int enterRingFd = Native.ioUringRegisterRingFds(this.ringFd);
        if (enterRingFd < 0) {
            enterRingFd = this.ringFd;
            enterFlags = 0;
        } else {
            enterFlags = 16;
        }
        this.enterRingFd = enterRingFd;
        this.enterFlags = enterFlags;
    }

    private long enqueueSqe0(byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        this.setData(sqe, opcode, flags, ioPrio, fd, union1, union2, len, union3, udata, union4, personality, union5, union6);
        return udata;
    }

    void enqueueSqe(byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        this.setData(sqe, opcode, flags, ioPrio, fd, union1, union2, len, union3, udata, union4, personality, union5, union6);
    }

    private void setData(long sqe, byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        PlatformDependent.putByte((long)(sqe + 0L), (byte)opcode);
        PlatformDependent.putByte((long)(sqe + 1L), (byte)flags);
        PlatformDependent.putShort((long)(sqe + 2L), (short)ioPrio);
        PlatformDependent.putInt((long)(sqe + 4L), (int)fd);
        PlatformDependent.putLong((long)(sqe + 8L), (long)union1);
        PlatformDependent.putLong((long)(sqe + 16L), (long)union2);
        PlatformDependent.putInt((long)(sqe + 24L), (int)len);
        PlatformDependent.putInt((long)(sqe + 28L), (int)union3);
        PlatformDependent.putLong((long)(sqe + 32L), (long)udata);
        PlatformDependent.putShort((long)(sqe + 40L), (short)union4);
        PlatformDependent.putShort((long)(sqe + 42L), (short)personality);
        PlatformDependent.putInt((long)(sqe + 44L), (int)union5);
        PlatformDependent.putLong((long)(sqe + 48L), (long)union6);
        if (logger.isTraceEnabled()) {
            if (opcode == 2 || opcode == 1) {
                logger.trace("add(ring={}, enterRing:{} ): {}(fd={}, len={} ({} bytes), off={}, data={})", new Object[]{this.ringFd, this.enterRingFd, Native.opToStr(opcode), fd, len, Iov.sumSize(union2, len), union1, udata});
            } else {
                logger.trace("add(ring={}, enterRing:{}): {}(fd={}, len={}, off={}, data={})", new Object[]{this.ringFd, this.enterRingFd, Native.opToStr(opcode), fd, len, union1, udata});
            }
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "SubmissionQueue [", "]");
        int pending = this.tail - this.head;
        for (int i = 0; i < pending; ++i) {
            long sqe = this.submissionQueueArrayAddress + (long)(this.head + i & this.ringMask) * 64L;
            sb.add(Native.opToStr(PlatformDependent.getByte((long)(sqe + 0L))) + "(fd=" + PlatformDependent.getInt((long)(sqe + 4L)) + ')');
        }
        return sb.toString();
    }

    long addNop(byte flags, long udata) {
        return this.enqueueSqe0((byte)0, flags, (short)0, -1, 0L, 0L, 0, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addTimeout(long timeoutMemoryAddress, long udata) {
        return this.enqueueSqe0((byte)11, (byte)0, (short)0, -1, 1L, timeoutMemoryAddress, 1, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addLinkTimeout(long timeoutMemoryAddress, long extraData) {
        return this.enqueueSqe0((byte)15, (byte)0, (short)0, -1, 1L, timeoutMemoryAddress, 1, 0, extraData, (short)0, (short)0, 0, 0L);
    }

    long addEventFdRead(int fd, long bufferAddress, int pos, int limit, long udata) {
        return this.enqueueSqe0((byte)22, (byte)0, (short)0, fd, 0L, bufferAddress + (long)pos, limit - pos, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addCancel(long sqeToCancel, long udata) {
        return this.enqueueSqe0((byte)14, (byte)0, (short)0, -1, 0L, sqeToCancel, 0, 0, udata, (short)0, (short)0, 0, 0L);
    }

    int submit() {
        int submit = this.tail - this.head;
        return submit > 0 ? this.submit(submit, 0, 0) : 0;
    }

    int submitAndWait() {
        int submit = this.tail - this.head;
        if (submit > 0) {
            return this.submit(submit, 1, Native.IORING_ENTER_GETEVENTS);
        }
        assert (submit == 0);
        int ret = this.ioUringEnter(0, 1, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int submit(int toSubmit, int minComplete, int flags) {
        PlatformDependent.putIntOrdered((long)this.kTailAddress, (int)this.tail);
        int ret = this.ioUringEnter(toSubmit, minComplete, flags);
        this.head = PlatformDependent.getIntVolatile((long)this.kHeadAddress);
        if (ret != toSubmit && ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int ioUringEnter(int toSubmit, int minComplete, int flags) {
        int f = this.enterFlags | flags;
        if (IoUring.isSetupSubmitAllSupported()) {
            return this.ioUringEnter0(toSubmit, minComplete, f);
        }
        int submitted = 0;
        int ret;
        while ((ret = this.ioUringEnter0(toSubmit, minComplete, f)) >= 0) {
            submitted += ret;
            if (ret == toSubmit) {
                return submitted;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Not all submissions succeeded. Only {} of {} SQEs were submitted.", (Object)ret, (Object)toSubmit);
            }
            toSubmit -= ret;
        }
        return ret;
    }

    private int ioUringEnter0(int toSubmit, int minComplete, int f) {
        if (logger.isTraceEnabled()) {
            logger.trace("io_uring_enter(ring={}, enterRing={}, toSubmit={}, minComplete={}, flags={}): {}", new Object[]{this.ringFd, this.enterRingFd, toSubmit, minComplete, f, this.toString()});
        }
        return Native.ioUringEnter(this.enterRingFd, toSubmit, minComplete, f);
    }

    public int count() {
        return this.tail - this.head;
    }

    public int remaining() {
        return this.ringEntries - this.count();
    }
}

