/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Native;
import io.netty.util.internal.ObjectUtil;

public final class IoUringIoHandlerConfiguration {
    private int ringSize = Native.DEFAULT_RING_SIZE;
    private int maxBoundedWorker;
    private int maxUnboundedWorker;

    public int getRingSize() {
        return this.ringSize;
    }

    public int getMaxBoundedWorker() {
        return this.maxBoundedWorker;
    }

    public int getMaxUnboundedWorker() {
        return this.maxUnboundedWorker;
    }

    public IoUringIoHandlerConfiguration setRingSize(int ringSize) {
        this.ringSize = ObjectUtil.checkPositive((int)ringSize, (String)"ringSize");
        return this;
    }

    public IoUringIoHandlerConfiguration setMaxBoundedWorker(int maxBoundedWorker) {
        this.maxBoundedWorker = ObjectUtil.checkPositiveOrZero((int)maxBoundedWorker, (String)"maxBoundedWorker");
        return this;
    }

    public IoUringIoHandlerConfiguration setMaxUnboundedWorker(int maxUnboundedWorker) {
        this.maxUnboundedWorker = ObjectUtil.checkPositiveOrZero((int)maxUnboundedWorker, (String)"maxUnboundedWorker");
        return this;
    }

    boolean needRegisterIowqMaxWorker() {
        return this.maxBoundedWorker > 0 || this.maxUnboundedWorker > 0;
    }
}

