/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Native;
import io.netty.channel.uring.RingBuffer;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class IoUring {
    private static final Throwable UNAVAILABILITY_CAUSE;
    private static final boolean IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    private static final boolean IORING_SPLICE_SUPPORTED;
    private static final boolean IORING_ACCEPT_NO_WAIT_SUPPORTED;
    private static final boolean IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    static boolean isIOUringCqeFSockNonEmptySupported() {
        return IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    }

    static boolean isIOUringSpliceSupported() {
        return IORING_SPLICE_SUPPORTED;
    }

    static boolean isIOUringAcceptNoWaitSupported() {
        return IORING_ACCEPT_NO_WAIT_SUPPORTED;
    }

    static boolean isRegisterIowqMaxWorkersSupported() {
        return IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private IoUring() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean registerIowqWorkersSupported;
        boolean acceptSupportNoWait;
        boolean spliceSupported;
        boolean socketNonEmptySupported;
        Throwable cause;
        block16: {
            cause = null;
            socketNonEmptySupported = false;
            spliceSupported = false;
            acceptSupportNoWait = false;
            registerIowqWorkersSupported = false;
            try {
                if (SystemPropertyUtil.getBoolean((String)"io.netty.transport.noNative", (boolean)false)) {
                    cause = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
                    break block16;
                }
                String kernelVersion = Native.kernelVersion();
                Native.checkKernelVersion(kernelVersion);
                Throwable unsafeCause = PlatformDependent.getUnsafeUnavailabilityCause();
                if (unsafeCause == null) {
                    RingBuffer ringBuffer = null;
                    try {
                        ringBuffer = Native.createRingBuffer();
                        Native.checkAllIOSupported(ringBuffer.fd());
                        socketNonEmptySupported = Native.isIOUringCqeFSockNonEmptySupported(ringBuffer.fd());
                        spliceSupported = Native.isIOUringSupportSplice(ringBuffer.fd());
                        acceptSupportNoWait = (ringBuffer.features() & 0x4000) != 0;
                        registerIowqWorkersSupported = Native.isRegisterIOWQWorkerSupported(ringBuffer.fd());
                        break block16;
                    }
                    finally {
                        if (ringBuffer != null) {
                            try {
                                ringBuffer.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                cause = new UnsupportedOperationException("Unsafe is not supported", unsafeCause);
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (cause != null) {
            InternalLogger logger = InternalLoggerFactory.getInstance(IoUring.class);
            if (logger.isTraceEnabled()) {
                logger.debug("IoUring support is not available", cause);
            } else if (logger.isDebugEnabled()) {
                logger.debug("IoUring support is not available: {}", (Object)cause.getMessage());
            }
        }
        UNAVAILABILITY_CAUSE = cause;
        IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED = socketNonEmptySupported;
        IORING_SPLICE_SUPPORTED = spliceSupported;
        IORING_ACCEPT_NO_WAIT_SUPPORTED = acceptSupportNoWait;
        IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED = registerIowqWorkersSupported;
    }
}

