/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Iov;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.UserData;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.StringJoiner;
import java.util.function.IntSupplier;

final class SubmissionQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SubmissionQueue.class);
    private static final long SQE_SIZE = 64L;
    private static final int INT_SIZE = 4;
    private static final int KERNEL_TIMESPEC_SIZE = 16;
    private static final int SQE_OP_CODE_FIELD = 0;
    private static final int SQE_FLAGS_FIELD = 1;
    private static final int SQE_IOPRIO_FIELD = 2;
    private static final int SQE_FD_FIELD = 4;
    private static final int SQE_OFFSET_FIELD = 8;
    private static final int SQE_ADDRESS_FIELD = 16;
    private static final int SQE_LEN_FIELD = 24;
    private static final int SQE_RW_FLAGS_FIELD = 28;
    private static final int SQE_USER_DATA_FIELD = 32;
    private static final int SQE_PAD_FIELD = 40;
    private static final int KERNEL_TIMESPEC_TV_SEC_FIELD = 0;
    private static final int KERNEL_TIMESPEC_TV_NSEC_FIELD = 8;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long kFlagsAddress;
    private final long kDroppedAddress;
    private final long kArrayAddress;
    final long submissionQueueArrayAddress;
    final int ringEntries;
    private final int ringMask;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    private final long timeoutMemoryAddress;
    private final IntSupplier completionCount;
    private int numHandledFds;
    private int head;
    private int tail;

    SubmissionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kFlagsAddress, long kDroppedAddress, long kArrayAddress, long submissionQueueArrayAddress, int ringSize, long ringAddress, int ringFd, IntSupplier completionCount) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.kFlagsAddress = kFlagsAddress;
        this.kDroppedAddress = kDroppedAddress;
        this.kArrayAddress = kArrayAddress;
        this.submissionQueueArrayAddress = submissionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.head = PlatformDependent.getIntVolatile((long)kHeadAddress);
        this.tail = PlatformDependent.getIntVolatile((long)kTailAddress);
        this.timeoutMemoryAddress = PlatformDependent.allocateMemory((long)16L);
        this.completionCount = completionCount;
        PlatformDependent.setMemory((long)submissionQueueArrayAddress, (long)((long)this.ringEntries * 64L), (byte)0);
        long address = kArrayAddress;
        int i = 0;
        while (i < this.ringEntries) {
            PlatformDependent.putInt((long)address, (int)i);
            ++i;
            address += 4L;
        }
    }

    void incrementHandledFds() {
        ++this.numHandledFds;
    }

    void decrementHandledFds() {
        --this.numHandledFds;
        assert (this.numHandledFds >= 0);
    }

    long enqueueSqe(byte op, int flags, short ioPrio, int rwFlags, int fd, long bufferAddress, int length, long offset, int id, short data) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        long udata = UserData.encode(id, op, data);
        this.setData(sqe, op, flags, ioPrio, rwFlags, fd, bufferAddress, length, offset, udata);
        return udata;
    }

    void enqueueSqe(byte op, int flags, short ioPrio, int rwFlags, int fd, long bufferAddress, int length, long offset, long udata) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        this.setData(sqe, op, flags, ioPrio, rwFlags, fd, bufferAddress, length, offset, udata);
    }

    private void setData(long sqe, byte op, int flags, short ioPrio, int rwFlags, int fd, long bufferAddress, int length, long offset, long udata) {
        PlatformDependent.putByte((long)(sqe + 0L), (byte)op);
        PlatformDependent.putByte((long)(sqe + 1L), (byte)((byte)flags));
        PlatformDependent.putShort((long)(sqe + 2L), (short)ioPrio);
        PlatformDependent.putInt((long)(sqe + 4L), (int)fd);
        PlatformDependent.putLong((long)(sqe + 8L), (long)offset);
        PlatformDependent.putLong((long)(sqe + 16L), (long)bufferAddress);
        PlatformDependent.putInt((long)(sqe + 24L), (int)length);
        PlatformDependent.putInt((long)(sqe + 28L), (int)rwFlags);
        PlatformDependent.putLong((long)(sqe + 32L), (long)udata);
        if (logger.isTraceEnabled()) {
            if (op == 2 || op == 1) {
                logger.trace("add(ring {}): {}(fd={}, len={} ({} bytes), off={}, data={})", new Object[]{this.ringFd, Native.opToStr(op), fd, length, Iov.sumSize(bufferAddress, length), offset, udata});
            } else {
                logger.trace("add(ring {}): {}(fd={}, len={}, off={}, data={})", new Object[]{this.ringFd, Native.opToStr(op), fd, length, offset, udata});
            }
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "SubmissionQueue [", "]");
        int pending = this.tail - this.head;
        for (int i = 0; i < pending; ++i) {
            long sqe = this.submissionQueueArrayAddress + (long)(this.head + i & this.ringMask) * 64L;
            sb.add(Native.opToStr(PlatformDependent.getByte((long)(sqe + 0L))) + "(fd=" + PlatformDependent.getInt((long)(sqe + 4L)) + ')');
        }
        return sb.toString();
    }

    long addNop(int fd, int flags, int id, short data) {
        return this.enqueueSqe((byte)0, flags, (short)0, 0, fd, 0L, 0, 0L, id, data);
    }

    long addTimeout(int fd, long nanoSeconds, int id, short extraData) {
        this.setTimeout(nanoSeconds);
        return this.enqueueSqe((byte)11, 0, (short)0, 0, fd, this.timeoutMemoryAddress, 1, 0L, id, extraData);
    }

    long addLinkTimeout(int fd, long nanoSeconds, int id, short extraData) {
        this.setTimeout(nanoSeconds);
        return this.enqueueSqe((byte)15, 0, (short)0, 0, fd, this.timeoutMemoryAddress, 1, 0L, id, extraData);
    }

    long addEventFdRead(int fd, long bufferAddress, int pos, int limit, int id, short extraData) {
        return this.enqueueSqe((byte)22, 0, (short)0, 0, fd, bufferAddress + (long)pos, limit - pos, 0L, id, extraData);
    }

    long addCancel(int fd, long sqeToCancel, int id) {
        return this.enqueueSqe((byte)14, 0, (short)0, 0, fd, sqeToCancel, 0, 0L, id, (short)0);
    }

    int submit() {
        int submit = this.tail - this.head;
        return submit > 0 ? this.submit(submit, 0, 0) : 0;
    }

    int submitAndWait() {
        int submit = this.tail - this.head;
        if (submit > 0) {
            return this.submit(submit, 1, Native.IORING_ENTER_GETEVENTS);
        }
        assert (submit == 0);
        int ret = Native.ioUringEnter(this.ringFd, 0, 1, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int submit(int toSubmit, int minComplete, int flags) {
        if (logger.isTraceEnabled()) {
            logger.trace("submit(ring {}): {}", (Object)this.ringFd, (Object)this.toString());
        }
        PlatformDependent.putIntOrdered((long)this.kTailAddress, (int)this.tail);
        int ret = Native.ioUringEnter(this.ringFd, toSubmit, minComplete, flags);
        this.head = PlatformDependent.getIntVolatile((long)this.kHeadAddress);
        if (ret != toSubmit) {
            if (ret < 0) {
                throw new RuntimeException("ioUringEnter syscall returned " + ret);
            }
            logger.warn("Not all submissions succeeded. Only {} of {} SQEs were submitted, while there are {} pending completions.", new Object[]{ret, toSubmit, this.completionCount.getAsInt()});
        }
        return ret;
    }

    private void setTimeout(long timeoutNanoSeconds) {
        long nanoSeconds;
        long seconds;
        if (timeoutNanoSeconds == 0L) {
            seconds = 0L;
            nanoSeconds = 0L;
        } else {
            seconds = (int)Math.min(timeoutNanoSeconds / 1000000000L, Integer.MAX_VALUE);
            nanoSeconds = (int)Math.max(timeoutNanoSeconds - seconds * 1000000000L, 0L);
        }
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 0L), (long)seconds);
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 8L), (long)nanoSeconds);
    }

    public int count() {
        return this.tail - this.head;
    }

    public int remaining() {
        return this.ringEntries - this.count();
    }

    public void release() {
        PlatformDependent.freeMemory((long)this.timeoutMemoryAddress);
    }
}

