/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

final class SockaddrIn {
    static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    static final int IPV4_ADDRESS_LENGTH = 4;
    static final int IPV6_ADDRESS_LENGTH = 16;

    private SockaddrIn() {
    }

    static int write(boolean ipv6, long memory, InetSocketAddress address) {
        if (ipv6) {
            return SockaddrIn.writeIPv6(memory, address.getAddress(), address.getPort());
        }
        return SockaddrIn.writeIPv4(memory, address.getAddress(), address.getPort());
    }

    static int writeIPv4(long memory, InetAddress address, int port) {
        PlatformDependent.setMemory((long)memory, (long)Native.SIZEOF_SOCKADDR_IN, (byte)0);
        PlatformDependent.putShort((long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_FAMILY), (short)Native.AF_INET);
        PlatformDependent.putShort((long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT), (short)SockaddrIn.handleNetworkOrder((short)port));
        byte[] bytes = address.getAddress();
        int offset = 0;
        if (bytes.length == 16) {
            offset = IPV4_MAPPED_IPV6_PREFIX.length;
        }
        assert (bytes.length == offset + 4);
        PlatformDependent.copyMemory((byte[])bytes, (int)offset, (long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + (long)Native.IN_ADDRESS_OFFSETOF_S_ADDR), (long)4L);
        return Native.SIZEOF_SOCKADDR_IN;
    }

    static int writeIPv6(long memory, InetAddress address, int port) {
        PlatformDependent.setMemory((long)memory, (long)Native.SIZEOF_SOCKADDR_IN6, (byte)0);
        PlatformDependent.putShort((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY), (short)Native.AF_INET6);
        PlatformDependent.putShort((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT), (short)SockaddrIn.handleNetworkOrder((short)port));
        byte[] bytes = address.getAddress();
        if (bytes.length == 4) {
            int offset = Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + Native.IN6_ADDRESS_OFFSETOF_S6_ADDR;
            PlatformDependent.copyMemory((byte[])IPV4_MAPPED_IPV6_PREFIX, (int)0, (long)(memory + (long)offset), (long)IPV4_MAPPED_IPV6_PREFIX.length);
            PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(memory + (long)offset + (long)IPV4_MAPPED_IPV6_PREFIX.length), (long)4L);
        } else {
            PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + (long)Native.IN6_ADDRESS_OFFSETOF_S6_ADDR), (long)16L);
            PlatformDependent.putInt((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID), (int)((Inet6Address)address).getScopeId());
        }
        return Native.SIZEOF_SOCKADDR_IN6;
    }

    static InetSocketAddress readIPv4(long memory, byte[] tmpArray) {
        assert (tmpArray.length == 4);
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort((long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT))) & 0xFFFF;
        PlatformDependent.copyMemory((long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + (long)Native.IN_ADDRESS_OFFSETOF_S_ADDR), (byte[])tmpArray, (int)0, (long)4L);
        try {
            return new InetSocketAddress(InetAddress.getByAddress(tmpArray), port);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    static InetSocketAddress readIPv6(long memory, byte[] ipv6Array, byte[] ipv4Array) {
        assert (ipv6Array.length == 16);
        assert (ipv4Array.length == 4);
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT))) & 0xFFFF;
        PlatformDependent.copyMemory((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + (long)Native.IN6_ADDRESS_OFFSETOF_S6_ADDR), (byte[])ipv6Array, (int)0, (long)16L);
        if (PlatformDependent.equals((byte[])ipv6Array, (int)0, (byte[])IPV4_MAPPED_IPV6_PREFIX, (int)0, (int)IPV4_MAPPED_IPV6_PREFIX.length)) {
            System.arraycopy(ipv6Array, IPV4_MAPPED_IPV6_PREFIX.length, ipv4Array, 0, 4);
            try {
                return new InetSocketAddress(Inet4Address.getByAddress(ipv4Array), port);
            }
            catch (UnknownHostException ignore) {
                return null;
            }
        }
        int scopeId = PlatformDependent.getInt((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID));
        try {
            return new InetSocketAddress(Inet6Address.getByAddress(null, ipv6Array, scopeId), port);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    static boolean hasPortIpv4(long memory) {
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort((long)(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT))) & 0xFFFF;
        return port > 0;
    }

    static boolean hasPortIpv6(long memory) {
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort((long)(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT))) & 0xFFFF;
        return port > 0;
    }

    private static short handleNetworkOrder(short v) {
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
    }
}

