/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.DatagramUnicastTest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class DatagramUnicastInetTest
extends DatagramUnicastTest {
    @Test
    public void testBindWithPortOnly(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastInetTest.testBindWithPortOnly(bootstrap2);
            }
        });
    }

    private static void testBindWithPortOnly(Bootstrap cb) throws Throwable {
        Channel channel = null;
        try {
            cb.handler((ChannelHandler)new ChannelHandlerAdapter(){});
            channel = cb.bind(0).sync().channel();
        }
        catch (Throwable throwable) {
            DatagramUnicastInetTest.closeChannel(channel);
            throw throwable;
        }
        DatagramUnicastInetTest.closeChannel(channel);
    }

    @Override
    protected boolean isConnected(Channel channel) {
        return ((DatagramChannel)channel).isConnected();
    }

    @Override
    protected Channel setupClientChannel(Bootstrap cb, final byte[] bytes, final CountDownLatch latch, final AtomicReference<Throwable> errorRef) throws Throwable {
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
                try {
                    ByteBuf buf = (ByteBuf)msg.content();
                    Assertions.assertEquals((int)bytes.length, (int)buf.readableBytes());
                    for (int i = 0; i < bytes.length; ++i) {
                        Assertions.assertEquals((byte)bytes[i], (byte)buf.getByte(buf.readerIndex() + i));
                    }
                    InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
                    if (localAddress.getAddress().isAnyLocalAddress()) {
                        Assertions.assertEquals((int)localAddress.getPort(), (int)((InetSocketAddress)msg.recipient()).getPort());
                    } else {
                        Assertions.assertEquals((Object)localAddress, (Object)msg.recipient());
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                errorRef.compareAndSet(null, cause);
            }
        });
        return cb.bind(this.newSocketAddress()).sync().channel();
    }

    @Override
    protected Channel setupServerChannel(Bootstrap sb, final byte[] bytes, final SocketAddress sender, final CountDownLatch latch, final AtomicReference<Throwable> errorRef, final boolean echo) throws Throwable {
        sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
                        try {
                            if (sender == null) {
                                Assertions.assertNotNull((Object)msg.sender());
                            } else {
                                InetSocketAddress senderAddress = (InetSocketAddress)sender;
                                if (senderAddress.getAddress().isAnyLocalAddress()) {
                                    Assertions.assertEquals((int)senderAddress.getPort(), (int)((InetSocketAddress)msg.sender()).getPort());
                                } else {
                                    Assertions.assertEquals((Object)sender, (Object)msg.sender());
                                }
                            }
                            ByteBuf buf = (ByteBuf)msg.content();
                            Assertions.assertEquals((int)bytes.length, (int)buf.readableBytes());
                            for (int i = 0; i < bytes.length; ++i) {
                                Assertions.assertEquals((byte)bytes[i], (byte)buf.getByte(buf.readerIndex() + i));
                            }
                            Assertions.assertEquals((Object)ctx.channel().localAddress(), (Object)msg.recipient());
                            if (echo) {
                                ctx.writeAndFlush((Object)new DatagramPacket(buf.retainedDuplicate(), (InetSocketAddress)msg.sender()));
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        errorRef.compareAndSet(null, cause);
                    }
                }});
            }
        });
        return sb.bind(this.newSocketAddress()).sync().channel();
    }

    @Override
    protected boolean supportDisconnect() {
        return true;
    }

    @Override
    protected ChannelFuture write(Channel cc, ByteBuf buf, SocketAddress remote, DatagramUnicastTest.WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)new DatagramPacket(buf.retainedDuplicate(), (InetSocketAddress)remote));
            }
            case SLICE: {
                return cc.write((Object)new DatagramPacket(buf.retainedSlice(), (InetSocketAddress)remote));
            }
            case READ_ONLY: {
                return cc.write((Object)new DatagramPacket(buf.retain().asReadOnly(), (InetSocketAddress)remote));
            }
            case NONE: {
                return cc.write((Object)new DatagramPacket(buf.retain(), (InetSocketAddress)remote));
            }
        }
        throw new Error("Unexpected wrap type: " + (Object)((Object)wrapType));
    }
}

