/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.concurrent.AutoScalingEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public abstract class AbstractSingleThreadEventLoopTest {
    protected static final int SCALING_MIN_THREADS = 1;
    protected static final int SCALING_MAX_THREADS = 2;
    protected static final long SCALING_WINDOW_SECONDS = 100L;
    protected static final TimeUnit SCALING_WINDOW_UNIT = TimeUnit.MILLISECONDS;
    protected static final double SCALEDOWN_THRESHOLD = 0.2;
    protected static final double SCALEUP_THRESHOLD = 0.9;
    protected static final int SCALING_PATIENCE_CYCLES = 1;
    protected static final EventExecutorChooserFactory AUTO_SCALING_CHOOSER_FACTORY = new AutoScalingEventExecutorChooserFactory(1, 2, 100L, SCALING_WINDOW_UNIT, 0.2, 0.9, 2, 2, 1);
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsRegistered() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            boolean channelCountSupported;
            Channel ch1 = this.newChannel();
            Channel ch2 = this.newChannel();
            int rc = AbstractSingleThreadEventLoopTest.registeredChannels(loop);
            boolean bl = channelCountSupported = rc != -1;
            if (channelCountSupported) {
                Assertions.assertEquals((int)0, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            }
            Assertions.assertTrue((boolean)loop.register(ch1).syncUninterruptibly().isSuccess());
            Assertions.assertTrue((boolean)loop.register(ch2).syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                AbstractSingleThreadEventLoopTest.checkNumRegisteredChannels(loop, 2);
            }
            Assertions.assertTrue((boolean)ch1.deregister().syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                AbstractSingleThreadEventLoopTest.checkNumRegisteredChannels(loop, 1);
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void checkNumRegisteredChannels(SingleThreadEventLoop loop, int numChannels) throws Exception {
        while (AbstractSingleThreadEventLoopTest.registeredChannels(loop) != numChannels) {
            Thread.sleep(50L);
        }
    }

    private static int registeredChannels(final SingleThreadEventLoop loop) throws Exception {
        return (Integer)loop.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return loop.registeredChannels();
            }
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void shutdownBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertFalse((boolean)group.awaitTermination(2L, TimeUnit.MILLISECONDS));
        group.shutdown();
        Assertions.assertTrue((boolean)group.awaitTermination(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownGracefullyZeroQuietBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertTrue((boolean)group.shutdownGracefully(0L, 2L, TimeUnit.SECONDS).await(200L));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(loop).channel(this.serverChannelClass())).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture cf = this.serverChannelClass() == LocalServerChannel.class ? b.bind((SocketAddress)new LocalAddress("local")) : b.bind(0);
        cf.sync().channel();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assertions.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)loop.isShutdown());
        Assertions.assertTrue((boolean)loop.isTerminated());
    }

    @Test
    public void shutdownGracefullyBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertTrue((boolean)group.shutdownGracefully(200L, 1000L, TimeUnit.MILLISECONDS).await(500L));
    }

    @Test
    public void gracefulShutdownAfterStart() throws Exception {
        EventLoop loop = this.newEventLoopGroup().next();
        final CountDownLatch latch = new CountDownLatch(1);
        loop.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        loop.shutdownGracefully(200L, 3000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)loop.awaitTermination(500L, TimeUnit.MILLISECONDS));
        AbstractSingleThreadEventLoopTest.assertRejection((EventExecutor)loop);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorEmpty() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    final Iterator iterator = loop.registeredChannelsIterator();
                    Assertions.assertFalse((boolean)iterator.hasNext());
                    Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

                        public void execute() {
                            iterator.next();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIterator() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            final Channel ch1 = this.newChannel();
            final Channel ch2 = this.newChannel();
            loop.register(ch1).syncUninterruptibly();
            loop.register(ch2).syncUninterruptibly();
            Assertions.assertEquals((int)2, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    final Iterator iterator = loop.registeredChannelsIterator();
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Channel actualCh1 = (Channel)iterator.next();
                    Assertions.assertNotNull((Object)actualCh1);
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Channel actualCh2 = (Channel)iterator.next();
                    Assertions.assertNotNull((Object)actualCh2);
                    HashSet<Channel> expected = new HashSet<Channel>(4);
                    expected.add(ch1);
                    expected.add(ch2);
                    expected.remove(actualCh1);
                    expected.remove(actualCh2);
                    Assertions.assertTrue((boolean)expected.isEmpty());
                    Assertions.assertFalse((boolean)iterator.hasNext());
                    Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

                        public void execute() {
                            iterator.next();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorRemoveThrows() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            Channel ch = this.newChannel();
            loop.register(ch).syncUninterruptibly();
            Assertions.assertEquals((int)1, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

                        public void execute() {
                            loop.registeredChannelsIterator().remove();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void schedulingAndCancellingTasks() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        ArrayList<ScheduledFuture> tasks = new ArrayList<ScheduledFuture>();
        EventLoopGroup group = this.newEventLoopGroup();
        try {
            EventLoop eventLoop = group.next();
            for (int i = 0; i < 5000; ++i) {
                tasks.add(eventLoop.scheduleAtFixedRate(runnable, 1L, 1L, TimeUnit.MILLISECONDS));
                if (tasks.size() <= 500) continue;
                ((ScheduledFuture)tasks.get(PlatformDependent.threadLocalRandom().nextInt(tasks.size()))).cancel(false);
            }
            for (ScheduledFuture task : tasks) {
                task.cancel(false);
            }
            for (ScheduledFuture task : tasks) {
                task.await();
            }
            for (ScheduledFuture task : tasks) {
                if (task.isCancelled()) continue;
                task.sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testAutoScalingEventLoopGroupCanScaleDownAndBeUsed() throws Exception {
        EventLoopGroup group = this.newAutoScalingEventLoopGroup();
        if (group == null) {
            return;
        }
        try {
            AbstractSingleThreadEventLoopTest.startAllExecutors(group);
            Assertions.assertEquals((int)2, (int)AbstractSingleThreadEventLoopTest.countActiveExecutors(group), (String)"Group should start with max threads active.");
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (AbstractSingleThreadEventLoopTest.countActiveExecutors(group) > 1 && System.nanoTime() < deadline) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)1, (int)AbstractSingleThreadEventLoopTest.countActiveExecutors(group), (String)"Group did not scale down to min threads in time.");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSubmittingTaskWakesUpSuspendedExecutor() throws Exception {
        EventLoopGroup group = this.newAutoScalingEventLoopGroup();
        if (group == null) {
            return;
        }
        try {
            AbstractSingleThreadEventLoopTest.startAllExecutors(group);
            Assertions.assertEquals((int)2, (int)AbstractSingleThreadEventLoopTest.countActiveExecutors(group), (String)"Group should start with max threads.");
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (AbstractSingleThreadEventLoopTest.countActiveExecutors(group) > 1 && System.nanoTime() < deadline) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)1, (int)AbstractSingleThreadEventLoopTest.countActiveExecutors(group), (String)"Group did not scale down to min threads in time.");
            EventLoop suspendedLoop = null;
            for (EventExecutor exec : group) {
                if (!exec.isSuspended()) continue;
                suspendedLoop = (EventLoop)exec;
                break;
            }
            Assertions.assertNotNull(suspendedLoop, (String)"Could not find a suspended executor to test.");
            Future future = suspendedLoop.submit(() -> {});
            future.syncUninterruptibly();
            Assertions.assertFalse((boolean)suspendedLoop.isSuspended(), (String)"Executor should wake up after task submission.");
            Assertions.assertEquals((int)2, (int)AbstractSingleThreadEventLoopTest.countActiveExecutors(group), (String)"Active executor count should increase after wake-up.");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    private static int countActiveExecutors(EventLoopGroup group) {
        int activeCount = 0;
        for (EventExecutor executor : group) {
            if (executor.isSuspended()) continue;
            ++activeCount;
        }
        return activeCount;
    }

    private static void startAllExecutors(EventLoopGroup group) throws InterruptedException {
        CountDownLatch startLatch = new CountDownLatch(2);
        for (EventExecutor executor : group) {
            executor.execute(startLatch::countDown);
        }
        startLatch.await();
    }

    private static void runBlockingOn(EventLoop eventLoop, final Runnable action) {
        final Promise promise = eventLoop.newPromise();
        eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                    promise.setSuccess(null);
                }
                catch (Throwable t) {
                    promise.tryFailure(t);
                }
            }
        });
        try {
            promise.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Throwable cause = promise.cause();
        if (cause != null) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static void assertRejection(EventExecutor loop) {
        try {
            loop.execute(NOOP);
            Assertions.fail((String)"A task must be rejected after shutdown() is called.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean supportsChannelIteration() {
        return false;
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract EventLoopGroup newAutoScalingEventLoopGroup();

    protected abstract Channel newChannel();

    protected abstract Class<? extends ServerChannel> serverChannelClass();
}

