/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.TrustManagerFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@EnabledIf(value="supportKeyManagerAndTLS13")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class SocketSslLargeCertificateTest {
    private CertificateBuilder base;
    private X509Bundle rootCert;
    private MultiThreadIoEventLoopGroup group;

    @BeforeAll
    public void setUp() throws Exception {
        this.base = new CertificateBuilder().ecp256().setKeyUsage(true, new CertificateBuilder.KeyUsage[]{CertificateBuilder.KeyUsage.digitalSignature, CertificateBuilder.KeyUsage.keyCertSign});
        this.rootCert = this.base.copy().subject("cn=root.netty.io").setIsCertificateAuthority(true).buildSelfSigned();
        this.group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
    }

    @AfterAll
    public void tearDown() {
        this.group.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static boolean supportKeyManagerAndTLS13() {
        return OpenSsl.isAvailable() && OpenSsl.supportsKeyManagerFactory() && SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL);
    }

    public static Stream<Arguments> certExtensionSizes() {
        int defaultMaxHandshakeMessageLength = 16384;
        return IntStream.rangeClosed(defaultMaxHandshakeMessageLength - 768, defaultMaxHandshakeMessageLength).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"certExtensionSizes"})
    void resumptionWithLargeCertificates(int certExtensionSize) throws Exception {
        X509Bundle serverCert = this.base.copy().subject("cn=localhost").addExtendedKeyUsageServerAuth().buildIssuedBy(this.rootCert);
        byte[] extension = new byte[certExtensionSize];
        ThreadLocalRandom.current().nextBytes(extension);
        X509Bundle clientCert = this.base.copy().subject("cn=client").addExtendedKeyUsageClientAuth().addExtensionOctetString("1.2.840.113635.100.6.2.1", false, extension).buildIssuedBy(this.rootCert);
        TrustManagerFactory tmf = this.rootCert.toTrustManagerFactory();
        KeyManagerFactory serverKmf = serverCert.toKeyManagerFactory();
        KeyManagerFactory clientKmf = clientCert.toKeyManagerFactory();
        final SslContext serverSsl = SslContextBuilder.forServer((KeyManagerFactory)serverKmf).sslProvider(SslProvider.OPENSSL).trustManager(tmf).protocols(new String[]{"TLSv1.3"}).clientAuth(ClientAuth.REQUIRE).option((SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES, (Object)32768).build();
        final SslContext clientSsl = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).keyManager(clientKmf).trustManager(tmf).protocols(new String[]{"TLSv1.3"}).option((SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES, (Object)32768).serverName((SNIServerName)new SNIHostName("localhost")).endpointIdentificationAlgorithm(null).build();
        final Promise completion = ImmediateEventExecutor.INSTANCE.newPromise();
        ChannelFuture bindFuture = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{serverSsl.newHandler(ch.alloc())});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent) {
                            SslHandshakeCompletionEvent completionEvent = (SslHandshakeCompletionEvent)evt;
                            if (completionEvent.isSuccess()) {
                                ctx.writeAndFlush((Object)Unpooled.buffer());
                            } else {
                                completion.tryFailure((Throwable)new ExecutionException(completionEvent.cause()));
                                ctx.close();
                            }
                        }
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ctx.write(msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                        ctx.flush();
                    }
                }});
            }
        }).bind(InetAddress.getLoopbackAddress(), 0);
        Channel serverChannel = bindFuture.sync().channel();
        final InetSocketAddress serverAddress = (InetSocketAddress)serverChannel.localAddress();
        ChannelFuture connectFuture = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{clientSsl.newHandler(ch.alloc(), "localhost", serverAddress.getPort())});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                    private boolean receivedRead;

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent) {
                            SslHandshakeCompletionEvent completionEvent = (SslHandshakeCompletionEvent)evt;
                            if (completionEvent.isSuccess()) {
                                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"hello", (Charset)StandardCharsets.UTF_8));
                            } else {
                                completion.tryFailure((Throwable)new ExecutionException(completionEvent.cause()));
                                ctx.close();
                            }
                        }
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        this.receivedRead = true;
                        ReferenceCountUtil.release((Object)msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                        ctx.fireChannelReadComplete();
                        if (this.receivedRead) {
                            this.receivedRead = false;
                            ctx.writeAndFlush((Object)Unpooled.buffer()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    completion.setSuccess(null);
                                }
                            });
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        completion.tryFailure(cause);
                        super.exceptionCaught(ctx, cause);
                    }
                }});
            }
        })).connect((SocketAddress)serverAddress);
        Channel clientChannel = connectFuture.sync().channel();
        completion.sync();
        clientChannel.close().sync();
        serverChannel.close().sync();
    }
}

