/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.testsuite.transport.AbstractTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import java.net.SocketException;
import java.nio.channels.NotYetConnectedException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketChannelNotYetConnectedTest
extends AbstractClientSocketTest {
    @Test
    @Timeout(value=30L)
    public void testShutdownNotYetConnected(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketChannelNotYetConnectedTest.this.testShutdownNotYetConnected(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownNotYetConnected(Bootstrap cb) throws Throwable {
        SocketChannel ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind(this.newSocketAddress()).syncUninterruptibly().channel();
        try {
            try {
                ch.shutdownInput().syncUninterruptibly();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (Throwable cause) {
                SocketChannelNotYetConnectedTest.checkThrowable(cause);
            }
            try {
                ch.shutdownOutput().syncUninterruptibly();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (Throwable cause) {
                SocketChannelNotYetConnectedTest.checkThrowable(cause);
            }
        }
        finally {
            ch.close().syncUninterruptibly();
        }
    }

    private static void checkThrowable(Throwable cause) throws Throwable {
        if (!(cause instanceof NotYetConnectedException) && !(cause instanceof SocketException)) {
            throw cause;
        }
    }

    @Test
    @Timeout(value=30L)
    public void readMustBePendingUntilChannelIsActive(TestInfo info) throws Throwable {
        this.run(info, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
                ServerBootstrap sb = new ServerBootstrap().group((EventLoopGroup)group);
                Channel serverChannel = ((ServerBootstrap)sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        ctx.writeAndFlush((Object)Unpooled.copyInt((int)42));
                    }
                }).channel(NioServerSocketChannel.class)).bind(0).sync().channel();
                final CountDownLatch readLatch = new CountDownLatch(1);
                bootstrap.handler((ChannelHandler)new ByteToMessageDecoder(){

                    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                        org.junit.jupiter.api.Assertions.assertFalse((boolean)ctx.channel().isActive());
                        ctx.read();
                    }

                    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                        Assertions.assertThat((int)in.readableBytes()).isLessThanOrEqualTo(4);
                        if (in.readableBytes() == 4) {
                            Assertions.assertThat((int)in.readInt()).isEqualTo(42);
                            readLatch.countDown();
                        }
                    }
                });
                bootstrap.connect(serverChannel.localAddress()).sync();
                readLatch.await();
                group.shutdownGracefully().await();
            }
        });
    }
}

