/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketDataReadInitialStateTest
extends AbstractSocketTest {
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadOffNoDataReadUntilReadCalled(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketDataReadInitialStateTest.this.testAutoReadOffNoDataReadUntilReadCalled(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutoReadOffNoDataReadUntilReadCalled(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        int sleepMs = 100;
        try {
            sb.option(ChannelOption.AUTO_READ, (Object)false);
            sb.childOption(ChannelOption.AUTO_READ, (Object)false);
            cb.option(ChannelOption.AUTO_READ, (Object)false);
            final CountDownLatch serverReadyLatch = new CountDownLatch(1);
            final CountDownLatch acceptorReadLatch = new CountDownLatch(1);
            final CountDownLatch serverReadLatch = new CountDownLatch(1);
            final CountDownLatch clientReadLatch = new CountDownLatch(1);
            final AtomicReference serverConnectedChannelRef = new AtomicReference();
            sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            acceptorReadLatch.countDown();
                            ctx.fireChannelRead(msg);
                        }
                    }});
                }
            });
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    serverConnectedChannelRef.set(ch);
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                            ctx.writeAndFlush((Object)msg.retainedDuplicate());
                            serverReadLatch.countDown();
                        }
                    }});
                    serverReadyLatch.countDown();
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                        protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
                            clientReadLatch.countDown();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            clientChannel.writeAndFlush((Object)clientChannel.alloc().buffer().writeZero(1)).syncUninterruptibly();
            Thread.sleep(100L);
            Assertions.assertEquals((long)1L, (long)acceptorReadLatch.getCount());
            serverChannel.read();
            serverReadyLatch.await();
            Channel serverConnectedChannel = (Channel)serverConnectedChannelRef.get();
            Assertions.assertNotNull((Object)serverConnectedChannel);
            Thread.sleep(100L);
            Assertions.assertEquals((long)1L, (long)serverReadLatch.getCount());
            serverConnectedChannel.read();
            serverReadLatch.await();
            Thread.sleep(100L);
            Assertions.assertEquals((long)1L, (long)clientReadLatch.getCount());
            clientChannel.read();
            clientReadLatch.await();
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadOnDataReadImmediately(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketDataReadInitialStateTest.this.testAutoReadOnDataReadImmediately(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutoReadOnDataReadImmediately(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            sb.option(ChannelOption.AUTO_READ, (Object)true);
            sb.childOption(ChannelOption.AUTO_READ, (Object)true);
            cb.option(ChannelOption.AUTO_READ, (Object)true);
            final CountDownLatch serverReadLatch = new CountDownLatch(1);
            final CountDownLatch clientReadLatch = new CountDownLatch(1);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                            ctx.writeAndFlush((Object)msg.retainedDuplicate());
                            serverReadLatch.countDown();
                        }
                    }});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                        protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
                            clientReadLatch.countDown();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            clientChannel.writeAndFlush((Object)clientChannel.alloc().buffer().writeZero(1)).syncUninterruptibly();
            serverReadLatch.await();
            clientReadLatch.await();
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
        }
    }
}

