/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketConnectionAttemptTest;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class SocketTestPermutation {
    static final String BAD_HOST = SystemPropertyUtil.get((String)"io.netty.testsuite.badHost", (String)"198.51.100.254");
    static final int BAD_PORT = SystemPropertyUtil.getInt((String)"io.netty.testsuite.badPort", (int)65535);
    static final SocketTestPermutation INSTANCE;
    protected static final int BOSSES = 2;
    protected static final int WORKERS = 3;
    protected static final int OIO_SO_TIMEOUT = 10;
    protected final EventLoopGroup nioBossGroup = new MultiThreadIoEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-boss", true), NioIoHandler.newFactory());
    protected final EventLoopGroup nioWorkerGroup = new MultiThreadIoEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-worker", true), NioIoHandler.newFactory());
    protected final EventLoopGroup oioBossGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-boss", true));
    protected final EventLoopGroup oioWorkerGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-worker", true));

    protected <A extends AbstractBootstrap<?, ?>, B extends AbstractBootstrap<?, ?>> List<TestsuitePermutation.BootstrapComboFactory<A, B>> combo(List<TestsuitePermutation.BootstrapFactory<A>> sbfs, List<TestsuitePermutation.BootstrapFactory<B>> cbfs) {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>>();
        for (TestsuitePermutation.BootstrapFactory<A> sbf : sbfs) {
            for (TestsuitePermutation.BootstrapFactory<B> cbf : cbfs) {
                final TestsuitePermutation.BootstrapFactory<A> sbf0 = sbf;
                final TestsuitePermutation.BootstrapFactory<B> cbf0 = cbf;
                list.add(new TestsuitePermutation.BootstrapComboFactory<A, B>(){

                    @Override
                    public A newServerInstance() {
                        return sbf0.newInstance();
                    }

                    @Override
                    public B newClientInstance() {
                        return cbf0.newInstance();
                    }
                });
            }
        }
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List sbfs = this.serverSocket();
        List cbfs = this.clientSocket();
        List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = this.combo(sbfs, cbfs);
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socketWithFastOpen() {
        List sbfs = this.serverSocket();
        List cbfs = this.clientSocketWithFastOpen();
        List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = this.combo(sbfs, cbfs);
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final SocketProtocolFamily family) {
        List bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.oioWorkerGroup)).channel(OioDatagramChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.nioBossGroup, SocketTestPermutation.this.nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.oioBossGroup, SocketTestPermutation.this.oioWorkerGroup).channel(OioServerSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.oioWorkerGroup)).channel(OioSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocketWithFastOpen() {
        return this.clientSocket();
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.nioWorkerGroup)).channel(NioDatagramChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.oioWorkerGroup)).channel(OioDatagramChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
    }

    static {
        InternalLogger logger = InternalLoggerFactory.getInstance(SocketConnectionAttemptTest.class);
        logger.debug("-Dio.netty.testsuite.badHost: {}", (Object)BAD_HOST);
        logger.debug("-Dio.netty.testsuite.badPort: {}", (Object)BAD_PORT);
        INSTANCE = new SocketTestPermutation();
    }
}

