/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ResumableX509ExtendedTrustManager;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SocketSslSessionReuseTest
extends AbstractSocketTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocketSslSessionReuseTest.class);
    private static final File CERT_FILE;
    private static final File KEY_FILE;

    public static Collection<Object[]> jdkOnly() throws Exception {
        return Collections.singleton(new Object[]{SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK), SslContextBuilder.forClient().trustManager(CERT_FILE).sslProvider(SslProvider.JDK).endpointIdentificationAlgorithm(null)});
    }

    public static Collection<Object[]> jdkAndOpenSSL() throws Exception {
        return Arrays.asList({SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK), SslContextBuilder.forClient().trustManager(CERT_FILE).sslProvider(SslProvider.JDK).endpointIdentificationAlgorithm(null)}, {SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.OPENSSL), SslContextBuilder.forClient().trustManager(CERT_FILE).sslProvider(SslProvider.OPENSSL).endpointIdentificationAlgorithm(null)});
    }

    @ParameterizedTest(name="{index}: serverEngine = {0}, clientEngine = {1}")
    @MethodSource(value={"jdkOnly"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testSslSessionReuse(final SslContextBuilder serverCtx, final SslContextBuilder clientCtx, TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketSslSessionReuseTest.this.testSslSessionReuse((ServerBootstrap)SocketSslSessionReuseTest.this.sb, (Bootstrap)SocketSslSessionReuseTest.this.cb, serverCtx.build(), clientCtx.build());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSslSessionReuse(ServerBootstrap sb, Bootstrap cb, final SslContext serverCtx, final SslContext clientCtx) throws Throwable {
        final ReadAndDiscardHandler sh = new ReadAndDiscardHandler(true, true);
        final ReadAndDiscardHandler ch = new ReadAndDiscardHandler(false, true);
        final String[] protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                SSLEngine engine = serverCtx.newEngine(sch.alloc());
                engine.setUseClientMode(false);
                engine.setEnabledProtocols(protocols);
                sch.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
                sch.pipeline().addLast(new ChannelHandler[]{sh});
            }
        });
        final Channel sc = sb.bind().sync().channel();
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                InetSocketAddress serverAddr = (InetSocketAddress)sc.localAddress();
                SSLEngine engine = clientCtx.newEngine(sch.alloc(), serverAddr.getHostString(), serverAddr.getPort());
                engine.setUseClientMode(true);
                engine.setEnabledProtocols(protocols);
                sch.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
                sch.pipeline().addLast(new ChannelHandler[]{ch});
            }
        });
        try {
            SSLSessionContext clientSessionCtx = clientCtx.sessionContext();
            ByteBuf msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            Channel cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).sync();
            cc.closeFuture().sync();
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
            Set<String> sessions = SocketSslSessionReuseTest.sessionIdSet(clientSessionCtx.getIds());
            msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).sync();
            cc.closeFuture().sync();
            Assertions.assertEquals(sessions, SocketSslSessionReuseTest.sessionIdSet(clientSessionCtx.getIds()), (String)"Expected no new sessions");
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
        }
        finally {
            sc.close().awaitUninterruptibly();
        }
    }

    @ParameterizedTest(name="{index}: serverEngine = {0}, clientEngine = {1}")
    @MethodSource(value={"jdkAndOpenSSL"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testSslSessionTrustManagerResumption(final SslContextBuilder serverCtx, final SslContextBuilder clientCtx, TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketSslSessionReuseTest.this.testSslSessionTrustManagerResumption((ServerBootstrap)SocketSslSessionReuseTest.this.sb, (Bootstrap)SocketSslSessionReuseTest.this.cb, serverCtx, clientCtx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSslSessionTrustManagerResumption(ServerBootstrap sb, Bootstrap cb, SslContextBuilder serverCtxBldr, SslContextBuilder clientCtxBldr) throws Throwable {
        String[] protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        serverCtxBldr.protocols(protocols);
        clientCtxBldr.protocols(protocols);
        SessionSettingTrustManager clientTrustManager = new SessionSettingTrustManager();
        clientCtxBldr.trustManager((TrustManager)clientTrustManager);
        final SslContext serverContext = serverCtxBldr.build();
        final SslContext clientContext = clientCtxBldr.build();
        final LinkedBlockingQueue sessionValue = new LinkedBlockingQueue();
        final ReadAndDiscardHandler sh = new ReadAndDiscardHandler(true, true);
        final ReadAndDiscardHandler ch = new ReadAndDiscardHandler(false, true){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    SslHandshakeCompletionEvent handshakeCompletionEvent = (SslHandshakeCompletionEvent)evt;
                    if (handshakeCompletionEvent.isSuccess()) {
                        SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                        Assertions.assertTrue((boolean)sessionValue.offer(String.valueOf(session.getValue("key"))));
                    } else {
                        logger.error("SSL handshake failed", handshakeCompletionEvent.cause());
                    }
                }
                super.userEventTriggered(ctx, evt);
            }
        };
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                sch.pipeline().addLast(new ChannelHandler[]{serverContext.newHandler(sch.alloc())});
                sch.pipeline().addLast(new ChannelHandler[]{sh});
            }
        });
        final Channel sc = sb.bind().sync().channel();
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                InetSocketAddress serverAddr = (InetSocketAddress)sc.localAddress();
                SslHandler sslHandler = clientContext.newHandler(sch.alloc(), serverAddr.getHostString(), serverAddr.getPort());
                sch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                sch.pipeline().addLast(new ChannelHandler[]{ch});
            }
        });
        try {
            ByteBuf msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            Channel cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).sync();
            cc.closeFuture().sync();
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
            Assertions.assertEquals((Object)"value", sessionValue.poll(10L, TimeUnit.SECONDS));
            msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).sync();
            cc.closeFuture().sync();
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
            Assertions.assertEquals((Object)"value", sessionValue.poll(10L, TimeUnit.SECONDS));
        }
        finally {
            sc.close().awaitUninterruptibly();
        }
    }

    private static void rethrowHandlerExceptions(ReadAndDiscardHandler sh, ReadAndDiscardHandler ch) throws Throwable {
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw new ExecutionException(sh.exception.get());
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw new ExecutionException(ch.exception.get());
        }
        if (sh.exception.get() != null) {
            throw new ExecutionException(sh.exception.get());
        }
        if (ch.exception.get() != null) {
            throw new ExecutionException(ch.exception.get());
        }
    }

    private static Set<String> sessionIdSet(Enumeration<byte[]> sessionIds) {
        HashSet<String> idSet = new HashSet<String>();
        while (sessionIds.hasMoreElements()) {
            byte[] id = sessionIds.nextElement();
            idSet.add(ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])id)));
        }
        return idSet;
    }

    static {
        try {
            X509Bundle cert = new CertificateBuilder().subject("cn=localhost").setIsCertificateAuthority(true).buildSelfSigned();
            CERT_FILE = cert.toTempCertChainPem();
            KEY_FILE = cert.toTempPrivateKeyPem();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class SessionSettingTrustManager
    extends X509ExtendedTrustManager
    implements ResumableX509ExtendedTrustManager {
        private SessionSettingTrustManager() {
        }

        public void resumeServerTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
            engine.getSession().putValue("key", "value");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            engine.getHandshakeSession().putValue("key", "value");
        }

        public void resumeClientTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("Unsupported operation");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @ChannelHandler.Sharable
    private static class ReadAndDiscardHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        private final boolean server;
        private final boolean autoRead;

        ReadAndDiscardHandler(boolean server, boolean autoRead) {
            this.server = server;
            this.autoRead = autoRead;
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            in.skipBytes(in.readableBytes());
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the " + (this.server ? "server" : "client") + " side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

