/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.AbstractTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketShutdownOutputBySelfTest
extends AbstractClientSocketTest {
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownOutput(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketShutdownOutputBySelfTest.this.testShutdownOutput(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutput(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        SocketChannel ch = null;
        try {
            ss.bind(this.newSocketAddress());
            ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assertions.assertTrue((boolean)ch.isActive());
            Assertions.assertFalse((boolean)ch.isOutputShutdown());
            s = ss.accept();
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1})).sync();
            Assertions.assertEquals((int)1, (int)s.getInputStream().read());
            Assertions.assertTrue((boolean)h.ch.isOpen());
            Assertions.assertTrue((boolean)h.ch.isActive());
            Assertions.assertFalse((boolean)h.ch.isInputShutdown());
            Assertions.assertFalse((boolean)h.ch.isOutputShutdown());
            ch.shutdownOutput().sync();
            Assertions.assertEquals((int)-1, (int)s.getInputStream().read());
            Assertions.assertTrue((boolean)h.ch.isOpen());
            Assertions.assertTrue((boolean)h.ch.isActive());
            Assertions.assertFalse((boolean)h.ch.isInputShutdown());
            Assertions.assertTrue((boolean)h.ch.isOutputShutdown());
            s.getOutputStream().write(new byte[]{1});
            Assertions.assertEquals((int)1, (int)h.queue.take().byteValue());
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (ch != null) {
                ch.close();
            }
            ss.close();
        }
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownOutputAfterClosed(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketShutdownOutputBySelfTest.this.testShutdownOutputAfterClosed(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutputAfterClosed(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        try {
            ss.bind(this.newSocketAddress());
            SocketChannel ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assertions.assertTrue((boolean)ch.isActive());
            s = ss.accept();
            ch.close().syncUninterruptibly();
            try {
                ch.shutdownInput().syncUninterruptibly();
                Assertions.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
            try {
                ch.shutdownOutput().syncUninterruptibly();
                Assertions.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            ss.close();
        }
    }

    @Disabled
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testWriteAfterShutdownOutputNoWritabilityChange(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketShutdownOutputBySelfTest.this.testWriteAfterShutdownOutputNoWritabilityChange(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteAfterShutdownOutputNoWritabilityChange(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        SocketChannel ch = null;
        try {
            ss.bind(this.newSocketAddress());
            cb.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2, 4));
            ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assumptions.assumeFalse((boolean)(ch instanceof OioSocketChannel));
            Assertions.assertTrue((boolean)ch.isActive());
            Assertions.assertFalse((boolean)ch.isOutputShutdown());
            s = ss.accept();
            byte[] expectedBytes = new byte[]{1, 2, 3, 4, 5, 6};
            ChannelFuture writeFuture = ch.write((Object)Unpooled.wrappedBuffer((byte[])expectedBytes));
            h.assertWritability(false);
            ch.flush();
            writeFuture.sync();
            h.assertWritability(true);
            for (int i = 0; i < expectedBytes.length; ++i) {
                Assertions.assertEquals((int)expectedBytes[i], (int)s.getInputStream().read());
            }
            Assertions.assertTrue((boolean)h.ch.isOpen());
            Assertions.assertTrue((boolean)h.ch.isActive());
            Assertions.assertFalse((boolean)h.ch.isInputShutdown());
            Assertions.assertFalse((boolean)h.ch.isOutputShutdown());
            ch.shutdownOutput().sync();
            Assertions.assertEquals((int)-1, (int)s.getInputStream().read());
            Assertions.assertTrue((boolean)h.ch.isOpen());
            Assertions.assertTrue((boolean)h.ch.isActive());
            Assertions.assertFalse((boolean)h.ch.isInputShutdown());
            Assertions.assertTrue((boolean)h.ch.isOutputShutdown());
            try {
                ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{2})).sync();
                Assertions.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
            Assertions.assertNull((Object)h.writabilityQueue.poll());
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (ch != null) {
                ch.close();
            }
            ss.close();
        }
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownOutputSoLingerNoAssertError(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketShutdownOutputBySelfTest.this.testShutdownOutputSoLingerNoAssertError(bootstrap);
            }
        });
    }

    public void testShutdownOutputSoLingerNoAssertError(Bootstrap cb) throws Throwable {
        this.testShutdownSoLingerNoAssertError0(cb, true);
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownSoLingerNoAssertError(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                SocketShutdownOutputBySelfTest.this.testShutdownSoLingerNoAssertError(bootstrap);
            }
        });
    }

    public void testShutdownSoLingerNoAssertError(Bootstrap cb) throws Throwable {
        this.testShutdownSoLingerNoAssertError0(cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testShutdownSoLingerNoAssertError0(Bootstrap cb, boolean output) throws Throwable {
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        ChannelFuture cf = null;
        try {
            ss.bind(this.newSocketAddress());
            cf = ((Bootstrap)((Bootstrap)cb.option(ChannelOption.SO_LINGER, (Object)1)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).connect(ss.getLocalSocketAddress()).sync();
            s = ss.accept();
            cf.sync();
            if (output) {
                ((SocketChannel)cf.channel()).shutdownOutput().sync();
            } else {
                ((SocketChannel)cf.channel()).shutdown().sync();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (cf != null) {
                cf.channel().close();
            }
            ss.close();
        }
    }

    private static void checkThrowable(Throwable cause) throws Throwable {
        if (!(cause instanceof ClosedChannelException) && !(cause instanceof SocketException)) {
            throw cause;
        }
    }

    private static final class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile SocketChannel ch;
        final BlockingQueue<Byte> queue = new LinkedBlockingQueue<Byte>();
        final BlockingDeque<Boolean> writabilityQueue = new LinkedBlockingDeque<Boolean>();

        private TestHandler() {
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            this.writabilityQueue.add(ctx.channel().isWritable());
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.ch = (SocketChannel)ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.queue.offer(msg.readByte());
        }

        private void drainWritabilityQueue() throws InterruptedException {
            while (this.writabilityQueue.poll(100L, TimeUnit.MILLISECONDS) != null) {
            }
        }

        void assertWritability(boolean isWritable) throws InterruptedException {
            try {
                Boolean writability = this.writabilityQueue.takeLast();
                Assertions.assertEquals((Object)isWritable, (Object)writability);
                this.drainWritabilityQueue();
            }
            catch (Throwable c) {
                c.printStackTrace();
            }
        }
    }
}

