/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class CompositeBufferGatheringWriteTest
extends AbstractSocketTest {
    private static final int EXPECTED_BYTES = 20;

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testSingleCompositeBufferWrite(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                CompositeBufferGatheringWriteTest.this.testSingleCompositeBufferWrite(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleCompositeBufferWrite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        block6: {
            Channel serverChannel = null;
            Channel clientChannel = null;
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference clientReceived = new AtomicReference();
                sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                ctx.writeAndFlush((Object)CompositeBufferGatheringWriteTest.newCompositeBuffer(ctx.alloc())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            }
                        }});
                    }
                });
                cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                            private ByteBuf aggregator;

                            public void handlerAdded(ChannelHandlerContext ctx) {
                                this.aggregator = ctx.alloc().buffer(20);
                            }

                            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                                try {
                                    if (msg instanceof ByteBuf) {
                                        this.aggregator.writeBytes((ByteBuf)msg);
                                    }
                                }
                                finally {
                                    ReferenceCountUtil.release((Object)msg);
                                }
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                if (!(cause instanceof IOException)) {
                                    clientReceived.set(cause);
                                    latch.countDown();
                                }
                            }

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                if (clientReceived.compareAndSet(null, this.aggregator)) {
                                    try {
                                        Assertions.assertEquals((int)20, (int)this.aggregator.readableBytes());
                                    }
                                    catch (Throwable cause) {
                                        this.aggregator.release();
                                        this.aggregator = null;
                                        clientReceived.set(cause);
                                    }
                                    finally {
                                        latch.countDown();
                                    }
                                }
                            }
                        }});
                    }
                });
                serverChannel = sb.bind().syncUninterruptibly().channel();
                clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
                ByteBuf expected = CompositeBufferGatheringWriteTest.newCompositeBuffer(clientChannel.alloc());
                latch.await();
                Object received = clientReceived.get();
                if (received instanceof ByteBuf) {
                    ByteBuf actual = (ByteBuf)received;
                    Assertions.assertEquals((Object)expected, (Object)actual);
                    expected.release();
                    actual.release();
                    break block6;
                }
                expected.release();
                throw (Throwable)received;
            }
            finally {
                if (clientChannel != null) {
                    clientChannel.close().sync();
                }
                if (serverChannel != null) {
                    serverChannel.close().sync();
                }
            }
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testCompositeBufferPartialWriteDoesNotCorruptData(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                CompositeBufferGatheringWriteTest.this.testCompositeBufferPartialWriteDoesNotCorruptData(serverBootstrap, bootstrap);
            }
        });
    }

    protected void compositeBufferPartialWriteDoesNotCorruptDataInitServerConfig(ChannelConfig config, int soSndBuf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompositeBufferPartialWriteDoesNotCorruptData(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        block6: {
            Channel serverChannel = null;
            Channel clientChannel = null;
            try {
                Random r = new Random();
                int soSndBuf = 1024;
                ByteBufAllocator alloc = ByteBufAllocator.DEFAULT;
                final ByteBuf expectedContent = alloc.buffer(2048);
                expectedContent.writeBytes(CompositeBufferGatheringWriteTest.newRandomBytes(expectedContent.writableBytes(), r));
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference clientReceived = new AtomicReference();
                sb.childOption(ChannelOption.SO_SNDBUF, (Object)1024).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                CompositeBufferGatheringWriteTest.this.compositeBufferPartialWriteDoesNotCorruptDataInitServerConfig(ctx.channel().config(), 1024);
                                int offset = 924;
                                ctx.write((Object)expectedContent.retainedSlice(expectedContent.readerIndex(), offset));
                                CompositeByteBuf compositeByteBuf = ctx.alloc().compositeBuffer();
                                compositeByteBuf.addComponent(true, expectedContent.retainedSlice(expectedContent.readerIndex() + offset, 50));
                                compositeByteBuf.addComponent(true, expectedContent.retainedSlice(expectedContent.readerIndex() + (offset += 50), 200));
                                ctx.write((Object)compositeByteBuf);
                                ctx.write((Object)expectedContent.retainedSlice(expectedContent.readerIndex() + (offset += 200), 50));
                                ctx.writeAndFlush((Object)expectedContent.retainedSlice(expectedContent.readerIndex() + (offset += 50), expectedContent.readableBytes() - expectedContent.readerIndex() - offset)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                if (!(cause instanceof IOException)) {
                                    clientReceived.set(cause);
                                    latch.countDown();
                                }
                            }
                        }});
                    }
                });
                cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                            private ByteBuf aggregator;

                            public void handlerAdded(ChannelHandlerContext ctx) {
                                this.aggregator = ctx.alloc().buffer(expectedContent.readableBytes());
                            }

                            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                                try {
                                    if (msg instanceof ByteBuf) {
                                        this.aggregator.writeBytes((ByteBuf)msg);
                                    }
                                }
                                finally {
                                    ReferenceCountUtil.release((Object)msg);
                                }
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                if (!(cause instanceof IOException)) {
                                    clientReceived.set(cause);
                                    latch.countDown();
                                }
                            }

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                if (clientReceived.compareAndSet(null, this.aggregator)) {
                                    try {
                                        Assertions.assertEquals((int)expectedContent.readableBytes(), (int)this.aggregator.readableBytes());
                                    }
                                    catch (Throwable cause) {
                                        this.aggregator.release();
                                        this.aggregator = null;
                                        clientReceived.set(cause);
                                    }
                                    finally {
                                        latch.countDown();
                                    }
                                }
                            }
                        }});
                    }
                });
                serverChannel = sb.bind().syncUninterruptibly().channel();
                clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
                latch.await();
                Object received = clientReceived.get();
                if (received instanceof ByteBuf) {
                    ByteBuf actual = (ByteBuf)received;
                    Assertions.assertEquals((Object)expectedContent, (Object)actual);
                    expectedContent.release();
                    actual.release();
                    break block6;
                }
                expectedContent.release();
                throw (Throwable)received;
            }
            finally {
                if (clientChannel != null) {
                    clientChannel.close().sync();
                }
                if (serverChannel != null) {
                    serverChannel.close().sync();
                }
            }
        }
    }

    private static ByteBuf newCompositeBuffer(ByteBufAllocator alloc) {
        CompositeByteBuf compositeByteBuf = alloc.compositeBuffer();
        compositeByteBuf.addComponent(true, alloc.directBuffer(4).writeInt(100));
        compositeByteBuf.addComponent(true, alloc.directBuffer(8).writeLong(123L));
        compositeByteBuf.addComponent(true, alloc.directBuffer(8).writeLong(456L));
        Assertions.assertEquals((int)20, (int)compositeByteBuf.readableBytes());
        return compositeByteBuf;
    }

    private static byte[] newRandomBytes(int size, Random r) {
        byte[] bytes = new byte[size];
        r.nextBytes(bytes);
        return bytes;
    }
}

