/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.sctp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.sctp.SctpTestPermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public abstract class AbstractSctpTest
extends AbstractComboTestsuiteTest<ServerBootstrap, Bootstrap> {
    protected volatile InetSocketAddress addr;

    protected AbstractSctpTest() {
        super(ServerBootstrap.class, Bootstrap.class);
    }

    @Override
    protected List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> newFactories() {
        return SctpTestPermutation.sctpChannel();
    }

    @Override
    protected void configure(ServerBootstrap serverBootstrap, Bootstrap bootstrap, ByteBufAllocator allocator) {
        this.addr = new InetSocketAddress(NetUtil.LOCALHOST, TestUtils.getFreePort());
        serverBootstrap.localAddress((SocketAddress)this.addr);
        serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        bootstrap.remoteAddress((SocketAddress)this.addr);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
    }
}

