/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.svm;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.testsuite.svm.HttpNativeServerHandler;
import java.util.concurrent.CompletableFuture;

public class HttpNativeServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final CompletableFuture<Void> httpRequestFuture;

    public HttpNativeServerInitializer(CompletableFuture<Void> httpRequestFuture) {
        this.httpRequestFuture = httpRequestFuture;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        p.addLast(new ChannelHandler[]{new HttpNativeServerHandler(this.httpRequestFuture)});
    }
}

