/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.util.internal.EmptyArrays;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class X509Bundle {
    private final X509Certificate[] certPath;
    private final X509Certificate root;
    private final KeyPair keyPair;

    private X509Bundle(X509Certificate[] certPath, X509Certificate root, KeyPair keyPair) {
        Objects.requireNonNull(root, "root");
        Objects.requireNonNull(keyPair, "keyPair");
        this.certPath = certPath.length > 1 && certPath[certPath.length - 1].equals(root) ? Arrays.copyOf(certPath, certPath.length - 1) : (X509Certificate[])certPath.clone();
        this.root = root;
        this.keyPair = keyPair;
    }

    public static X509Bundle fromRootCertificateAuthority(X509Certificate root, KeyPair keyPair) {
        Objects.requireNonNull(root, "root");
        Objects.requireNonNull(keyPair, "keyPair");
        X509Bundle bundle = new X509Bundle(new X509Certificate[]{root}, root, keyPair);
        if (!bundle.isCertificateAuthority() || !bundle.isSelfSigned()) {
            throw new IllegalArgumentException("Given certificate is not a root CA certificate: " + root.getSubjectX500Principal() + ", issued by " + root.getIssuerX500Principal());
        }
        return bundle;
    }

    public static X509Bundle fromCertificatePath(X509Certificate[] certPath, X509Certificate root, KeyPair keyPair) {
        return new X509Bundle(certPath, root, keyPair);
    }

    public X509Certificate getCertificate() {
        return this.certPath[0];
    }

    public String getCertificatePEM() {
        return X509Bundle.toCertPem(this.certPath[0]);
    }

    public X509Certificate[] getCertificatePath() {
        return (X509Certificate[])this.certPath.clone();
    }

    public X509Certificate[] getCertificatePathWithRoot() {
        X509Certificate[] path = Arrays.copyOf(this.certPath, this.certPath.length + 1);
        path[path.length - 1] = this.root;
        return path;
    }

    public List<X509Certificate> getCertificatePathList() {
        return Arrays.asList(this.certPath);
    }

    public String getCertificatePathPEM() {
        return X509Bundle.toCertPem(this.certPath);
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public X509Certificate getRootCertificate() {
        return this.root;
    }

    public String getRootCertificatePEM() {
        return X509Bundle.toCertPem(this.root);
    }

    private static String toCertPem(X509Certificate ... certs) {
        Base64.Encoder encoder = X509Bundle.getMimeEncoder();
        StringBuilder sb = new StringBuilder();
        for (X509Certificate cert : certs) {
            sb.append("-----BEGIN CERTIFICATE-----\r\n");
            try {
                sb.append(encoder.encodeToString(cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new IllegalStateException(e);
            }
            sb.append("\r\n-----END CERTIFICATE-----\r\n");
        }
        return sb.toString();
    }

    public String getPrivateKeyPEM() {
        Base64.Encoder encoder = X509Bundle.getMimeEncoder();
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PRIVATE KEY-----\r\n");
        PrivateKey privateKey = this.keyPair.getPrivate();
        sb.append(encoder.encodeToString(privateKey.getEncoded()));
        sb.append("\r\n-----END PRIVATE KEY-----\r\n");
        return sb.toString();
    }

    private static Base64.Encoder getMimeEncoder() {
        return Base64.getMimeEncoder(64, new byte[]{13, 10});
    }

    public TrustAnchor getTrustAnchor() {
        return new TrustAnchor(this.root, this.root.getExtensionValue("2.5.29.30"));
    }

    public boolean isCertificateAuthority() {
        return this.certPath[0].getBasicConstraints() != -1;
    }

    public boolean isSelfSigned() {
        X509Certificate leaf = this.certPath[0];
        return this.certPath.length == 1 && leaf.getSubjectX500Principal().equals(leaf.getIssuerX500Principal()) && Arrays.equals(leaf.getSubjectUniqueID(), leaf.getIssuerUniqueID());
    }

    public TrustManager toTrustManager() {
        TrustManagerFactory tmf = this.toTrustManagerFactory();
        return tmf.getTrustManagers()[0];
    }

    public TrustManagerFactory toTrustManagerFactory() {
        return this.toTrustManagerFactory(TrustManagerFactory.getDefaultAlgorithm());
    }

    public TrustManagerFactory toTrustManagerFactory(String algorithm) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(this.toKeyStore(EmptyArrays.EMPTY_CHARS));
            return tmf;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Default TrustManagerFactory algorithm was not available.", e);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Failed to initialize TrustManagerFactory with KeyStore.", e);
        }
    }

    public KeyStore toKeyStore(char[] keyEntryPassword) throws KeyStoreException {
        return this.toKeyStore("PKCS12", keyEntryPassword);
    }

    public KeyStore toKeyStore(String algorithm, char[] keyEntryPassword) throws KeyStoreException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(algorithm);
            keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Failed to initialize '" + algorithm + "' KeyStore.", e);
        }
        keyStore.setCertificateEntry("1", this.root);
        if (this.keyPair.getPrivate() != null) {
            keyStore.setKeyEntry("2", this.keyPair.getPrivate(), keyEntryPassword, this.certPath);
        }
        return keyStore;
    }

    public File toTempKeyStoreFile(char[] password) throws Exception {
        return this.toTempKeyStoreFile(password, password);
    }

    public File toTempKeyStoreFile(char[] pkcs12Password, char[] keyEntryPassword) throws Exception {
        KeyStore keyStore = this.toKeyStore(keyEntryPassword);
        Path tempFile = Files.createTempFile("ks", ".p12", new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, StandardOpenOption.WRITE);){
            keyStore.store(out, pkcs12Password);
        }
        File file = tempFile.toFile();
        file.deleteOnExit();
        return file;
    }

    public File toTempRootCertPem() throws IOException {
        return X509Bundle.createTempPemFile(this.getRootCertificatePEM(), "ca");
    }

    public File toTempCertChainPem() throws IOException {
        return X509Bundle.createTempPemFile(this.getCertificatePathPEM(), "chain");
    }

    public File toTempPrivateKeyPem() throws IOException {
        return X509Bundle.createTempPemFile(this.getPrivateKeyPEM(), "key");
    }

    private static File createTempPemFile(String pem, String filePrefix) throws IOException {
        Path tempFile = Files.createTempFile(filePrefix, ".pem", new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, StandardOpenOption.WRITE);){
            out.write(pem.getBytes(StandardCharsets.ISO_8859_1));
        }
        File file = tempFile.toFile();
        file.deleteOnExit();
        return file;
    }

    public KeyManagerFactory toKeyManagerFactory() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        return this.toKeyManagerFactory(KeyManagerFactory.getDefaultAlgorithm());
    }

    public KeyManagerFactory toKeyManagerFactory(String algorithm) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        KeyManagerFactory kmf;
        try {
            kmf = KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Default KeyManagerFactory algorithm was not available.", e);
        }
        kmf.init(this.toKeyStore(EmptyArrays.EMPTY_CHARS), EmptyArrays.EMPTY_CHARS);
        return kmf;
    }
}

