/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.pkitesting.Algorithms;
import io.netty.pkitesting.CertificateBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

final class MLDSASeedPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 4206741400099880395L;
    private final PrivateKey key;
    private final byte[] seedFormat;

    MLDSASeedPrivateKey(PrivateKey key, CertificateBuilder.Algorithm algorithm, byte[] seed) {
        this.key = key;
        try {
            this.seedFormat = new DERSequence(new ASN1Encodable[]{new ASN1Integer(0L), new DERSequence((ASN1Encodable)new ASN1ObjectIdentifier(Algorithms.oidForAlgorithmName(algorithm.signatureType))), new DEROctetString(seed)}).getEncoded("DER");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unexpected problem encoding private key DER", e);
        }
    }

    public AlgorithmParameterSpec getParams() {
        try {
            return (AlgorithmParameterSpec)this.key.getClass().getMethod("getParams", new Class[0]).invoke((Object)this.key, new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.seedFormat.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.key.destroy();
        Arrays.fill(this.seedFormat, (byte)0);
    }

    @Override
    public boolean isDestroyed() {
        return this.key.isDestroyed();
    }

    static PrivateKey unwrap(PrivateKey key) {
        if (key instanceof MLDSASeedPrivateKey) {
            return ((MLDSASeedPrivateKey)key).key;
        }
        return key;
    }
}

