/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.lang.reflect.Constructor;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class HeapByteBufBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"true", "false"})
    public String checkBounds;
    private ByteBuf unsafeBuffer;
    private ByteBuf buffer;

    private static ByteBuf newBuffer(String classname) throws Exception {
        Class<?> clazz = Class.forName(classname);
        Constructor<?> constructor = clazz.getDeclaredConstructor(ByteBufAllocator.class, Integer.TYPE, Integer.TYPE);
        constructor.setAccessible(true);
        return (ByteBuf)constructor.newInstance(ByteBufAllocator.DEFAULT, 8, Integer.MAX_VALUE);
    }

    @Setup
    public void setup() throws Exception {
        System.setProperty("io.netty.buffer.bytebuf.checkBounds", this.checkBounds);
        this.unsafeBuffer = HeapByteBufBenchmark.newBuffer("io.netty.buffer.UnpooledUnsafeHeapByteBuf");
        this.buffer = HeapByteBufBenchmark.newBuffer("io.netty.buffer.UnpooledHeapByteBuf");
        this.unsafeBuffer.writeLong(1L);
        this.buffer.writeLong(1L);
    }

    @TearDown
    public void destroy() {
        this.unsafeBuffer.release();
        this.buffer.release();
    }

    @Benchmark
    public byte getByteUnsafe() {
        return this.unsafeBuffer.getByte(0);
    }

    @Benchmark
    public short getByte() {
        return this.buffer.getByte(0);
    }

    @Benchmark
    public short getShortUnsafe() {
        return this.unsafeBuffer.getShort(0);
    }

    @Benchmark
    public short getShort() {
        return this.buffer.getShort(0);
    }

    @Benchmark
    public int getMediumUnsafe() {
        return this.unsafeBuffer.getMedium(0);
    }

    @Benchmark
    public int getMedium() {
        return this.buffer.getMedium(0);
    }

    @Benchmark
    public int getIntUnsafe() {
        return this.unsafeBuffer.getInt(0);
    }

    @Benchmark
    public int getInt() {
        return this.buffer.getInt(0);
    }

    @Benchmark
    public long getLongUnsafe() {
        return this.unsafeBuffer.getLong(0);
    }

    @Benchmark
    public long getLong() {
        return this.buffer.getLong(0);
    }
}

